#!/bin/bash

if [[ "$1" == "" ]] || [[ !  -w $1 ]]; then
	echo "supply a writable file list of only sorted single IP addresses in decimal format, see inetaton.sh and prips"
	exit 1
fi

if [[ "$2" != "" ]]; then
	slen=`printf %d $2`
	if [[ "$slen" == "" ]] ||  ((slen>31 || slen < 1)) ; then
		echo "slen not acceptable, must be greater than 0 and less than 32"
		exit
	fi
	if [[ "$3" != "" ]]; then
		fuzz=`printf %d $3`
		if ((fuzz > ((2**(32-slen))-1))); then
			echo "fuzz not acceptable"
		fi
	fi
else
	slen="29"
fi		

slend=$((-1<<(32-slen)))

if [[ "$fuzz" == "" ]]; then
	fuzz=$((((((2**(32-slen)) * 100) * 40)/10000)+1))
fi
maxhosts=$((2**(32-slen)))
minhosts=$((maxhosts-fuzz))

v4test() {
	read addr1 mask1 addr2 mask2
	if (( (addr1&mask2) == (addr2&mask2) && mask1 >= mask2 )); then
		return 0
	else
		return 1
	fi
}

inetntoa () {

    local IFS=. num quad ip e
    num=$1
    for e in 3 2 1
    do
        (( quad = 256 ** e))
        (( ip[3-e] = num / quad ))
        (( num = num % quad ))
    done
    ip[3]=$num
    echo "${ip[*]}"

}


while true; do
	i=0;
	unset INARR
	if [[ "$IN" == "" ]]; then
		read IN
	fi
	if [[ "$IN" == "" ]]; then
		break
	fi
	while ((++i<=maxhosts)); do
		((k++))
		if [[ "$IN" == "" ]]; then read IN; fi
		if [[ "$IN" == "" ]]; then break; fi
		if [[ "`printf %d $IN`" == "" ]]; then 
			echo "I only eat single IP addresses in integer form, sorted and uniq, one per line"
			exit 1
		fi
		INARR[$i]="$IN"
		if ((i==1)) ; then unset IN; continue; fi
		echo ${INARR[$i]} -1 ${INARR[1]} $slend | v4test
		if [[ "$?" == "0" ]]; then
			unset IN 
			continue
		fi
		((i--)) 
		break
	done 
	if [[ "${#INARR[@]}" == "0" ]] ; then break; fi

	if  (( i < minhosts )) ; then
		for ((j=1;j<=i;j++)); do
			echo "`inetntoa ${INARR[$j]}`/32 0"
		done
	else
		echo "`inetntoa ${INARR[1]}`/$slen $((maxhosts-i)) $i"
	fi
done < $1

		




