#!/bin/bash

which rtbh-lists-extra.sh >/dev/null  2>&1 || exit 1
which prips >/dev/null 2>&1 || exit 1
which rtbh-lists.sh >/dev/null  2>&1 || exit 1
NAME=${NAME:-"FireholLevel1"}
RTBH_ROUTE=${RTBH_ROUTE:-"/usr/local/bin/rtbh-quagga-add-child-routes.sh"}
RTBH_SCREEN_OVERRIDE_BGP="${RTBH_SCREEN_OVERRIDE_BGP} ${NAME,,}"
RTBH_CHK=`which rtbh-quagga-chk-route.sh 2>/dev/null`
RTBH_CHK=${RTBH_CHK:-false}

firehollevel1_process_input()
{

	while read INPUT; do
		if [[ "$INPUT" == "" ]]; then continue; fi
		if [[ "${INPUT:0:1}" == "#" ]]; then continue; fi
		NET="`echo $INPUT | cut -f2 -s -d'/'`"
		if [[ "$NET" != "" ]]; then	
			NET=`printf %d $NET` 2>/dev/null || continue
			(( NET == 0 )) && continue
			if (( NET > 25 )); then
				prips $INPUT
				continue
			fi
			$RTBH_CHK $INPUT >/dev/null && continue
			echo $INPUT 
		else
			echo "$INPUT/32"
		fi
	done
	return 0
}
INPUT_PROCESSOR="firehollevel1_process_input"

firehollevel1_process_output()
{

	oldIFS=$IFS
	IFS="/"
	local CIDRA=($PREFIX)
	local NET
	IFS="$oldIFS"	
	if [[ "${CIDRA[1]}" == "" ]]; then return 1; fi
	NET=`printf %d ${CIDRA[1]}` 2>/dev/null || return 1
	unset EXPIRES
	(( NET == 0 )) && return 1
	(( NET == 32 )) && [[ "$EXTRA" == "extra" ]] &&  return 1
	if (( NET < 25 )); then 
		if [[ "$EXTRA" == "extra" ]]; then
			EXPIRES="expires 1 HOURS"
			unset EXTRA
			return 0
		fi
		return 1
	fi
	return 0
}
OUTPUT_PROCESSOR="firehollevel1_process_output"

. `which rtbh-lists-extra.sh`
