#!/bin/bash

PATH=$PATH:/usr/local/bin:/usr/local/sbin
USER=autopilot
LISTS="/var/local/rtbh/lists/"

pr_random ()
{
        h=${1:-0}
        l=${2:-10}
        if [[ "${RANDOM}" == "" ]]; then
                n=32768
                while [ $n -ge 32768 ]; do
                        n=1$(</dev/urandom sed 's/[^0-9]*//g' | sed 's/^0//g' | dd bs=5 count=1 2>/dev/null)
                        n=`printf %d $n`
                        if [[ $n -ge 100000 ]]; then
                                n=$((n-100000))
                        fi
                done
        else
                n=$RANDOM
        fi
        echo $(( ( n * ( h-l+1 )) / 32768 + l))

}

curloadav()
{
	(IFS=$IFS. LD=(`cat /proc/loadavg`); echo ${LD[0]:-0})
}

pr_random 1 10

which updateweb2local >/dev/null || exit 0 
UPDATES=`find $LISTS -mindepth 1 -maxdepth 2 -type f -iname "update*"`
FOUND=`echo $UPDATES | wc -l`
if (( FOUND > 0)); then 
	. /usr/local/bin/rtbh-lists.func
	prepare_tmp_once
fi

for i in $UPDATES; do 
	if (( `ps --ppid $$ uw | grep -c "updateweb2local"` > 3 )) ||\
	   (( `curloadav` > 3 )); then
		sleepTIME="`pr_random 180 1800`"
	else
		sleepTIME="`pr_random 30 900`"
	fi
	
	for ((j=0;j<99;j++)); do
		if (( `curloadav` > 5 )); then 
			sleep `pr_random 5 90`
		else
			break
		fi
	done

	(timeout -k 15m 12h updateweb2local -s -f -i $i)&
	sleep $sleepTIME
done

