#!/bin/bash

which rtbh-lists-extra.sh >/dev/null  2>&1 || exit 1
NAME=${NAME:-"SpamHaus"}
RTBH_ROUTE=${RTBH_ROUTE:-"/usr/local/bin/rtbh-quagga-add-child-routes.sh"}
RTBH_SCREEN_OVERRIDE_BGP="${RTBH_SCREEN_OVERRIDE_BGP} ${NAME,,}"

spamhaus_process_input()
{

	local PREFIX
	local DESC
	local SUBN
	while read INPUT; do
		if [[ "$INPUT" == "" ]]; then continue; fi
		if [[ "${INPUT:0:1}" == "#" ]]; then continue; fi
		PREFIX="`echo $INPUT | cut -f1 -d';'`" 
		if [[ "$PREFIX" == "" ]]; then continue; fi
		echo ${PREFIX}
	done
}
INPUT_PROCESSOR="spamhaus_process_input"

spamhaus_process_output()
{
	test -n "$1" && test -r $1 || return 1
	test -n "$2" || return 1
	local INPUT=`grep "^$2" "$1"`
	local LDESC
	LDESC="`echo $INPUT | cut -f2 -d';'`" 
	test -z "$LDESC" && return 0
	DESC="$LDESC"
	unset EXPIRES
	unset EXTRA
	return 0
}
OUTPUT_PROCESSOR="spamhaus_process_output"

. `which rtbh-lists-extra.sh`
