#!/bin/bash

if [[ "$1" == "" ]]; then exit 1; fi

VTYSH_PROG=`which vtysh`
VTYSH_PAGER=more
LOGFACPRI=local5.info
LOGSTART=1
PATH="$PATH:`dirname $0`"

RTBH_ROUTE=${RTBH_ROUTE:-"rtbh-quagga-screen-add-route.sh"}
RTBH_DB_REPORT="rtbh-db.sh"

if [[ "${RTBH_ROUTE}" == "" ]] || [[ ! -x "`which ${RTBH_ROUTE}`" ]]; then
	echo "No route add cmd. suggest rtbh-quagga-screen-add-route.sh"
	exit 1
fi

GEOIPCONF=${GEOIPCONF:-"/var/local/rtbh/geoip.dat"}
GEOIPSTRING=${GEOIPSTRING:-"geoipblock"}
GEOIPLOOKUP=${GEOIPLOOKUP:-"geoiplookup"}

rtbh_geoip_enabled()
{
        if ! [[ -x "$GEOIPLOOKUP" ]]; then
                if [[ "`which $GEOIPLOOKUP 2>/dev/null`" == "" ]]; then
                        return 1
                fi
        fi
        if ! [[ -r "$GEOIPCONF" ]]; then return 1; fi
        return 0
}

rtbh_geoip_lookup_cc()
{
        local netcc
        if [[ "$1" == "" ]]; then return 1; fi
        netcc=`$GEOIPLOOKUP $1 | grep "ountry"`
	if [[ "$?" != "0" ]]; then return 1; fi
	netcc=`echo $netcc | cut -f2 -d: | cut -f1 -d, | tr -d '[[:space:]]'`
        if [[ "${#netcc}" -eq 2 ]]; then
                echo $netcc
	else
		echo "=="
        fi
	return 0
}


rtbh_geoip_child()
{
	local Name
	for Name in $*; do
		if [[ "${Name,,}" == "${GEOIPSTRING,,}" ]]; then
			return 0
		fi
	done
	return 1
}


rtbh_getaspath()
{
	if [[ "$1" == "" ]]; then return 1; fi
	local OUTPUT
	OUTPUT=`$VTYSH_PROG -c "show ip bgp $1"` || return 1
	if [[ "$OUTPUT" == "" ]]; then return 1; fi
	local ASpath;
	ASpath=(`echo "$OUTPUT" | while read LINE; do
		echo "$LINE" | grep -qE "[0-9]+\.[0-9]+\.[0-9]+\.[0-9]+ from [0-9]+\.[0-9]+\.[0-9]+\.[0-9]+"
		if [[ "$?" == "0" ]]; then
			echo $PREV
			break
		fi
		PREV="$LINE"
	done`)
	if [[ "$ASpath" == "Local" ]]; then return 0; fi 
	
	local ASpathC;
	local i;
	local j=1;
	local numpaths=${#ASpath[@]}
	ASpathC[0]=${ASpath[0]}
	for ((i=1;i<numpaths;i++)); do
		if [[ "${ASpath[(i-1)]}" == "${ASpath[(i)]}" ]]; then continue; fi
		ASpathC[(j++)]=${ASpath[i]}
	done
	echo "${ASpath[@]}:${ASpathC[@]}"
	return 0
}


rtbh_badpath()
{
	if [[ "$1" == "" ]]; then return 1; fi
	local i
	local numpaths=${#BAD_PATHS[@]}
	for ((i=0; i<numpaths; i++)); do
		if [[ "$*" == "${BAD_PATHS[i]}" ]]; then return 0; fi
	done
	return 1
}

if [[ "$VTYSH_PROG" == "" ]]; then exit 1; fi

echo $1 | grep -q '/' 2>&1 >/dev/null && SUBNET="/`echo $1 | cut -f2 -d'/'`"
if [[ "$SUBNET" == "" ]]; then
	NETWORK=$1
	if [[ "$2" != "" ]]; then 
		SUBNET=" mask $2"
		((LOGSTART++))
	else
		SUBNET="/32"
	fi
else
	NETWORK="`echo $1 | cut -f1 -d'/'`"
fi

if rtbh_geoip_enabled; then
	GEOIPCC=${GEOIPCC:-"`rtbh_geoip_lookup_cc $NETWORK`"}
	if [[ "$GEOIPCC" == "" ]]; then
		unset GEOIPLOOKUP
	fi
else
	unset GEOIPLOOKUP
fi

PNET=$1	

shift $LOGSTART

ROUTES=`$VTYSH_PROG -c "sh ip bgp $PNET longer-prefixes" | grep -Eo "[0-9]+\.[0-9]+\.[0-9]+\.[0-9]+/[0-9]+ " | grep -v /32`

PNET_PATH="`rtbh_getaspath $PNET | cut -f2 -d:`"
if [[ "$PNET_PATH" != "" ]]; then BAD_PATHS[0]="${PNET_PATH}"; fi

$RTBH_ROUTE $PNET $*
for r in $ROUTES; do
	if [[ "$r" == "$PNET" ]]; then 
		continue
	fi
	if rtbh_geoip_enabled; then
		rNET=`echo $r | cut -f1 -d/`
		if [[ "`rtbh_geoip_lookup_cc $rNET`" != "$GEOIPCC" ]]; then continue; fi
		rtbh_geoip_child $* || continue
		rPATH="`rtbh_getaspath $r | cut -f2 -d:`"
		if ! rtbh_badpath $rPATH; then
			which $RTBH_DB_REPORT 1>&2 >/dev/null &&\
			$RTBH_DB_REPORT geoip child $PNET report $r | grep -q "found" ||\
			continue
			numpaths=${#BAD_PATHS[@]}
			BAD_PATHS[numpaths]="$rPATH"
		fi
	fi
	RTBH_ROUTE_MAP_SUFFIX="child" RTBH_SCREEN_OVERRIDE_BGP="${RTBH_SCREEN_OVERRIDE_BGP}" $RTBH_ROUTE $r child $PNET $*
done

