#!/bin/bash

if [[ "$1" == "" ]]; then exit 1; fi

VTYSH_PROG=`which vtysh`
VTYSH_PAGER=more
LOGFACPRI=local5.info
LOGSTART=1
PATH="$PATH:`dirname $0`"
ROUTE_MAP=" route-map blackhole-nonchl"
unset ROUTE_MAP
RTBH_RETRY="${RTBH_RETRY:-"5"}"
RTBH_RETRY="`printf %d $RTBH_RETRY`" || RTBH_RETRY="1"
(( RTBH_RETRY > 0)) || RTBH_RETRY="1"


RTBH_CHK=`which rtbh-quagga-chk-route.sh 2> /dev/null` || RTBH_CHK=true

if [[ "$SSH_CLIENT" != "" ]]; then
	USERFROM="@`echo $SSH_CLIENT | cut -f1 -d' '`"
fi

if [[ "$VTYSH_PROG" == "" ]]; then exit 1; fi

echo $1 | grep -q '/' 2>&1 >/dev/null && SUBNET="/`echo $1 | cut -f2 -d'/'`"
if [[ "$SUBNET" == "" ]]; then
	NETWORK=$1
	if [[ "$2" != "" ]]; then 
		SUBNET=" mask $2"
		((LOGSTART++))
	else
		SUBNET="/32"
	fi
else
	NETWORK="`echo $1 | cut -f1 -d'/'`"
fi

CHKOUT=`RTBH_CHECK_FLAGS="LocalOnly Exact" $RTBH_CHK ${NETWORK}${SUBNET}`
if [[ "$?" == 0 ]]; then
	if [[ "$CHKOUT" != "" ]]; then
		echo "$CHKOUT" | grep -q " ${NETWORK}${SUBNET}"
		if [[ "$?" != 0 ]]; then
			echo "${NETWORK}${SUBNET} no rtbh $1 chk found $CHKOUT"
			exit 1
		fi
	fi
elif [[ "$?" -ge "2" ]]; then
	echo "${NETWORK}${SUBNET} no rtbh static $1"
	exit 1
else
	echo "${NETWORK}${SUBNET} no rtbh $1 chk failed"
	exit 1
fi

COMMAND_STR="conf t\nrouter bgp 21719\nno network ${NETWORK}${SUBNET}${ROUTE_MAP}\nend\nwri mem"

unset TIMEOUT_CMD
unset ERROUTPUT
unset TIMEDOUT
unset RTBH_RET
which timeout 2>&1 >/dev/null && TIMEOUT_CMD="timeout -k35 30"

if [[ "$RTBH_DB" == "" ]] || [[ ! -x "$RTBH_DB" ]]; then
	if which rtbh-db.sh >/dev/null; then
		DBCMD="del"
		if [[ "${RTBH_FORCE}" != "" ]]; then
			DBCMD="forcedel"
		fi
		echo "$0" | grep -q "force-del" && DBCMD="forcedel"
		$TIMEOUT_CMD rtbh-db.sh $DBCMD ${NETWORK}${SUBNET} $* 
		RTBH_RET=$?
	fi
fi

if  [[ "${RTBH_RET}" == "124" ]]; then
	ERROUTPUT="DB timed out"
	TIMEDOUT=1

elif  [[ "${RTBH_RET}" == "2" ]]; then
	ERROUTPUT="Not authorized"
        if (which logger > /dev/null); then

                logger -p $LOGFACPRI -t `basename $0` -- $USER$USERFROM remove refused ${NETWORK}${SUBNET} $*
	fi
else
	for ((i=0;i<RTBH_RETRY;i++)); do	
		OUTPUT=`echo -e "$COMMAND_STR" | VTYSH_PAGER=more $TIMEOUT_CMD $VTYSH_PROG `
		if  [[ "$?" == "124" ]]; then
			TIMEDOUT=2
			ERROUTPUT="$ERROUTPUT VTYSH timed out"
			if ((i+1 < RTBH_RETRY)); then continue; fi
		elif [[ "$OUTPUT" != "" ]]; then
			ERROUTPUT=`echo "$OUTPUT" | grep '^%'`
			if (( i+1 < RTBH_RETRY )); then
				echo "$OUTPUT" | grep -q "^% Unknown command" && continue
			fi
		fi
		break
	done
fi


if [[ "$ERROUTPUT" != "" ]] || [[ "$TIMEDOUT" == "2"  ]]; then
        echo "${NETWORK}${SUBNET} no rtbh $1 $ERROUTPUT" >&2
        exit 1
else
        shift $LOGSTART

        if (which logger > /dev/null); then

                logger -p $LOGFACPRI -t `basename $0` $USER$USERFROM removed ${NETWORK}${SUBNET} $*
        fi
        echo "removed ${NETWORK}${SUBNET} $*"
fi

