#!/bin/bash

if [[ "$1" == "" ]] || [[ ! -r "$1" ]]; then

	echo must provide non aggregated ip list
	echo optionally, also provide prefix len and acceptable miss rate, integers in that order
	exit 1

fi


escape_addr()
{

	if [[ "$1" == "" ]]; then return 1; fi

	local OLDIFS
	local IPAARR
	local PAT
	local i
	OLDIFS="$IFS"
	IFS="$IFS ."
	IPARR=($1)
	IFS="$OLDIFS"
	for ((i=0;i<4;i++)); do
		if [[ "${IPARR[$i]}" == "" ]]; then
			echo $PAT
			return 0
		fi
		PAT="${PAT}${IPARR[$i]}"
		if [[ "$i" -lt 3 ]]; then
			PAT="$PAT\\."
		fi
	done
	echo $PAT
	return

}

opat="([0-9]+)"

if [[ "$2" != "" ]]; then 
	slsh=$2
	if [[ $slsh -gt 31 ]] ; then
		echo prefix len less than 32 please
		exit 1
	fi
	if [[ $slsh -gt 24 ]]; then
		unset trail
		spat="^${opat}\.${opat}\.${opat}\."
		nlen=24
	elif [[ $slsh -gt 16 ]]; then
		trail=".0"
		spat="^${opat}\.${opat}\."
		nlen=16
	elif [[ $slsh -gt 8 ]]; then
		trail=".0.0"
		spat="^${opat}\."
		nlen=8
	else
		unset trail
		spat="^${opat}\.${opat}\.${opat}\."
		nlen=24
	fi
	if [[ "$3" != "" ]]; then
		fuzz=$3
		if [[ "$4" != "" ]]; then
			tpat="$4"
			while true; do 
				if [[ $nlen -eq "24" ]]; then
					echo "$tpat" | spat=`grep -Eo "${opat}.${opat}.${opat}\."` && { spat="${tpat}"; break ;}
					echo "$tpat" | spat=`grep -Eo "${opat}.${opat}.${opat}"` &&  { spat="${tpat}\.${opat}"; break ;}
					echo "$tpat" | spat=`grep -Eo "${opat}.${opat}."` && { spat="${tpat}${opat}\.${opat}"; break ;}
					echo "$tpat" | spat=`grep -Eo "${opat}.${opat}"` && { spat="${tpat}\.${opat}\.${opat}"; break ;}
					echo "$tpat" | spat=`grep -Eo "${opat}."` && { spat="${tpat}${opat}\.${opat}\.${opat}"; break ;}
					echo "$tpat" | spat=`grep -Eo "${opat}"` && { spat="${tpat}\.${opat}\.${opat}\.${opat}"; break ;}
				fi
				break
			done
			if [[ "$spat" == "" ]] || [[ "$spat" == "." ]]; then
				echo "supplied subnet subseti $4 invalid"
				exit 1
			fi
		fi
	fi
	
else
	unset trail
	fuzz=5
	slsh=28
	nlen=24
	spat="^${opat}\.${opat}\.${opat}\."
fi
((nets = slsh - nlen)) ; ((nets = 2 ** nets)) 


hostpat="([0-9]+)\.([0-9]+)\.([0-9]+)\.([0-9]+)"
((minhosts = 32 - slsh)); ((minhosts = 2 ** minhosts)) 

if [[ ! "$fuzz" -lt "$minhosts" ]]; then
	echo fuzz $fuzz for minhosts $minhosts not allowed
	exit 1
fi

 ((minhosts = minhosts - fuzz))


grep -Eo $spat $1 | sort | uniq | while read prefix; do 
	if [[ "$prefix" == "" ]]; then continue; fi
	for ((i=0;i<nets;i++)); do 
		((num = i * (256 / nets)))
		echo -e "${prefix}${num}${trail}/$slsh"
	done | while read input; do 
		grep `escape_addr $input` $1 && (echo "$input 0" ; continue)
		ppat=`escape_addr $prefix`
		CHECKFOR=`prips $input`
		CHECKIN=`grep "^$ppat.*/32" $1; grep "^$ppat.*" $1 | grep -v "^#" | grep -v ".*/.*";
			grep "^$ppati.*/.*" $1 | grep -v "^#" | grep -v "/32" | grep -v "/$slsh" | while read input; 
				do prips $input; 
			done`
		if [[ `echo $CHECKIN | wc -w` -lt minhosts ]]; then
			continue
		fi
		NF=`for i in $CHECKFOR; do 
			echo "$CHECKIN" | grep $(escape_addr $i ) || echo $i not found; 
		done | grep -c "not found"`
		
		echo "$input $NF" 
	done  | grep " [1-$fuzz]$" 
done 

