#!/bin/bash

RTBH_DB=${RTBH_DB:-rtbh-db.sh}
DRONEBL=${DRONEBL:-dronebl.sh}

DRONEBL_MATCHES=(6 13 17 15 19)

which ${RTBH_DB} >/dev/null || exit 1
which ${DRONEBL} >/dev/null || exit 1

if [[ "$1" != "" ]]; then 
	expTIME=$1
	shift
	if [[ "$1" != "" ]]; then
		DRONEBL_MATCHES=($*)
	fi
fi

i=0
${RTBH_DB} dump distinct active mask /32 format raw expires "${expTIME:-45:min}" |\
${DRONEBL} ${DRONEBL_MATCHES[@]} | grep 'matched$' | cut -f1 -d' ' |\
while read INPUT; do
	((i++))
	$RTBH_DB refresh $INPUT
done
