#!/bin/bash


VTYSH_PROG=`which vtysh`
VTYSH_PAGER=more

if [[ "$VTYSH_PROG" == "" ]]; then exit 1; fi


COMMAND_STR="conf t\nrouter bgp 21719\n"

while read INPUT; do


TARGETARR=($INPUT)
if [[ "${TARGETARR[1]}" == "" ]]; then
	echo $INPUT | grep -q '/' 2>&1 >/dev/null && SUBNET="/`echo $INPUT | cut -f2 -d'/'`"
	if [[ "$SUBNET" == "" ]]; then
		SUBNET="/32"
	else
		NETWORK="`echo $INPUT | cut -f1 -d'/'`"
	fi
	if [[ "$NETWORK" != "" ]] && [[ "$SUBNET" != "" ]]; then
		TARGET="${NETWORK}${SUBNET}"
	else
		TARGET="$INPUT"
	fi
else
	TARGET="${TARGETARR[0]} mask ${TARGETARR[1]}"

fi

COMMAND_STR="${COMMAND_STR}network ${TARGET} route-map  blackhole-nonchl\n"

done

COMMAND_STR="${COMMAND_STR}end\nwri mem\nexit"

echo -e "$COMMAND_STR" | VTYSH_PAGER=more $VTYSH_PROG
