#!/bin/bash

nameservers="1.1.1.1 8.8.8.8 9.9.9.9 debian53.ttec.com"
DIG_OPTS="+noqr +additional +answer +authority"
LOOPS=0

GREP_IP="[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}"
find_ns()
{

	while read INPUT; do
		if [[ "$INPUT" == "" ]]; then continue ; fi

		OUTPUT=($INPUT)

		j=${#OUTPUT[@]}
		for ((i=0; i < j ; i++ )); do
			if [[ "${OUTPUT[i],,}" == "soa" || "${OUTPUT[i],,}" == "ns" ]]; then
				for ((i++ ; i < j ; i++)); do
					if [[ "${OUTPUT[$i]}" != "" ]]; then
						echo "${OUTPUT[$i]}"
						break
					fi
				done
			fi

		done

	done
}

while  [[ "$1" != "" ]] ; do
	if ((loops++ > 10)); then break; fi

	unset DIG_OUTPUT
	unset DIG_OUTPUT1
	unset i

	if echo $1 | grep -q -Eo "$GREP_IP"; then

		HOSTLIST="$HOSTLIST $1"
		shift
		continue
	fi

	if [[ "$ARG1" == "" ]]; then
		ARG1=$1
	elif [[ "$ARG1" == "." ]]; then
		unset ARG1
		shift
		continue
	fi

	for ns in $nameservers; do	
		DIG_NS_OUTPUT="`dig $DIG_OPTS  ns $ARG1 @$ns | grep -v '^;'`"
		DIG_OUTPUT="`echo $DIG_NS_OUTPUT | grep -Eo "$GREP_IP" | grep -v '^;'| grep -v $ns`"
		for i in `echo $DIG_NS_OUTPUT | find_ns`; do
			for ns in $nameservers; do	
				DIG_OUTPUT1="`dig $DIG_OPTS $i @$ns | grep -v '^;' | grep -Eo "$GREP_IP" | grep -v $ns`"
				if [[ "$DIG_OUTPUT1" == "" ]]; then continue; fi
				break
			done
			if [[ "$DIG_OUTPUT1" == "" ]]; then continue; fi
			DIG_OUTPUT="$DIG_OUTPUT $DIG_OUTPUT1"
		done
		if [[ "$DIG_OUTPUT" == "" ]]; then continue; fi
		for ns in $nameservers; do	
			DIG_OUTPUT1="`dig $DIG_OPTS $ARG1 @$ns | grep -v '^;' | grep -Eo "$GREP_IP" | grep -v $ns`"
			if [[ "$DIG_OUTPUT1" == "" ]]; then continue; fi
			break
		done
		DIG_OUTPUT="$DIG_OUTPUT $DIG_OUTPUT1"
		break
	done
	HOSTLIST=`echo $HOSTLIST $DIG_OUTPUT | tr ' ' '\n' | sort | uniq | tr '\n' ' '`
	ARG2="${ARG1#*.}"	
	if [[ "$ARG2" == "$ARG1" ]]; then
		ARG1="."
	else
		ARG1="$ARG2"
	fi

done

for i in ${HOSTLIST}; do

	echo "Looking for $i `dig +short -x $i | tr '\n' ' '`"
	rtbh-db.sh listall $i || continue
	grep "$i" /var/log/rtbh || continue
	/usr/local/bin/rtbh-quagga-chk-route.sh $i || echo "Not currently blacklisted"
done
