#!/bin/bash

tmpNAME="${0##*-}"
tmpNAME="${tmpNAME%.sh}"
if [[ "${NAME,,}" == "generic" ]] || [[ "$NAME" == "" ]] && [[ "$tmpNAME" != "" ]]; then
        NAME="$tmpNAME"
else
	NAME="${NAME:-Generic}"
fi
RTBHDB=${RTBHDB:-"/usr/local/bin/rtbh-db.sh"}
RTBH=${RTBH:-"/usr/local/bin/rtbh-quagga-screen-add-route.sh"}
DESC=${DESC:-"attackers drop list"}
RTBH_LISTS=${RTBH_LISTS:-"/var/local/rtbh/lists/"}

if [[ "$#" -lt "2" ]]; then

	if [[ ! -d ${RTBH_LISTS} ]] ||\
	   [[ "$NAME" == "Generic" ]] ||\
	   [[ ! -x `which rtbh-lists-${NAME,,}.sh` ]] ||\
	   [[ ! -d ${RTBH_LISTS}/${NAME,,} ]]; then
		exit 1
	fi
	retVal=1
	for i in ${RTBH_LISTS}/${NAME,,}/update*; do
		(. $i ; test -r $CONF && test -r $TMP$FILE  &&  rtbh-lists-${NAME,,}.sh $CONF $TMP$FILE )
		retVal=$?
		if [[ "$retVal" != "0" ]]; then break; fi
	done
	exit $retVal
fi


if [[ "$EXPIRY" == "" ]]; then 
	((EXPIRY =( 60 * 60 * 24 * 2)))
fi

EXPIRES="expires $EXPIRY"

EXTRA="extra"

test -x "${RTBHDB}"  || ( echo "Need RTBH database command" ; exit 1 )
test -x "${RTBH}" || ( echo "Need RTBH add command" ; exit 1 )

if [[ -r $1 ]] || [[ -r $2 ]]; then
	. /usr/local/bin/rtbh-lists.func
	prepare_tmp_once not text dns not text $NAME not text lists
fi

default_process_input()
{
	while read INPUT; do
		if [[ "$INPUT" == "" ]]; then continue; fi
		if [[ "${INPUT:0:1}" == "#" ]]; then continue; fi
		echo ${INPUT%\r}/32
	done
	return 0
}

default_process_output()
{
	#$1 original input filename, $2 prefix being processed
	#customized version can update PREFIX or DESC
	#only called from subshell
	unset EXPIRES
	return 0
}

INPUT_PROCESSOR="${INPUT_PROCESSOR:-"default_process_input"}"
OUTPUT_PROCESSOR="${OUTPUT_PROCESSOR:-"default_process_output"}"

process_input()
{
	$INPUT_PROCESSOR $*
}

process_output()
{
	$OUTPUT_PROCESSOR $*
}

if [[ "$RENICE" == "" ]]; then
        RENICE=$((`curloadav`/3))
	((RENICE > 20)) && RENIC=20
        ((RENICE)) && renice +$((RENICE + `nice`)) $BASHPID
fi

if [[ -r $1 ]]; then

	grep -v "^#" $1 | process_input | sort | uniq > ${TMPFILE[1]}
	if [[ -r $2 ]]; then
		grep -v "^#" $2 | process_input > ${TMPFILE[2]}
		cat ${TMPFILE[2]} | sort | uniq > ${TMPFILE[4]} #4 is the newlist sorted
		if [[ -x `which ${RTBH_LISTS_EXTRA_ADD}` ]]; then
			cat ${TMPFILE[1]} > ${TMPFILE[5]} #save the oldlist sorted
		fi
		comm -23 ${TMPFILE[1]} ${TMPFILE[4]} > ${TMPFILE[3]}
		comm -12 ${TMPFILE[0]} ${TMPFILE[3]} > ${TMPFILE[2]}
	else
		comm -12 ${TMPFILE[0]}  ${TMPFILE[1]} > ${TMPFILE[2]}
	fi
	${RTBHDB} dump not deleted newer "1:week" format raw text $NAME | sort | uniq > ${TMPFILE[1]}	
	comm -12 ${TMPFILE[1]} ${TMPFILE[2]} > ${TMPFILE[3]}

	while read INPUT; do
		if [[ "$INPUT" == "" ]]; then continue; fi
		PREFIX=$INPUT
		( process_output $1 $PREFIX && ${RTBHDB} del $PREFIX Lists $NAME $DESC )
	done  < ${TMPFILE[3]}
fi	

if [[ -r $2 ]]; then

	if [[ -r $1 ]]; then
		cat ${TMPFILE[4]} > ${TMPFILE[2]}
	else
		grep -v "^#" $2 | process_input > ${TMPFILE[4]} 
		cat ${TMPFILE[4]} | sort | uniq > ${TMPFILE[2]}  #2 newlist, sorted
	fi
	if [[ -x `which ${RTBH_LISTS_EXTRA_ADD}` ]]; then
		if [[ -r "$1" ]]; then #5 is the oldlist sorted
			comm -13 ${TMPFILE[5]} ${TMPFILE[2]} > ${TMPFILE[3]} #3 is now only new entries
			EXTRA_INPUT=${TMPFILE[3]}
		else
			EXTRA_INPUT=${TMPFILE[2]}
		fi
		while read PREFIX; do
			if [[ "$PREFIX" == "" ]]; then continue; fi
			( process_output $2 $PREFIX &&\
			 ${RTBH_LISTS_EXTRA_ADD} add $PREFIX Lists $EXTRA $NAME $DESC $EXPIRES )
		done < ${EXTRA_INPUT}
	fi
	comm -12 ${TMPFILE[0]} ${TMPFILE[2]} > ${TMPFILE[3]} #3 is only newlist entries already otherwise seen
	${RTBHDB} dump active newer "1:week" format raw text $NAME | sort | uniq > ${TMPFILE[1]}
	comm -12 ${TMPFILE[1]} ${TMPFILE[3]} > ${TMPFILE[2]} #2 is subset refresh	
	while read INPUT; do
		if [[ "$INPUT" == "" ]]; then continue; fi
		PREFIX=$INPUT
		( process_output $2 $PREFIX &&\
		 ${RTBHDB} refresh $PREFIX Lists $NAME $DESC $EXPIRES )
	done < ${TMPFILE[2]}
	comm -13 ${TMPFILE[2]} ${TMPFILE[3]} > ${TMPFILE[1]} #1 is leftover 3	
	${RTBHDB} dump active newer "1:week" format raw not text $NAME | sort | uniq > ${TMPFILE[2]}
	comm -12 ${TMPFILE[1]} ${TMPFILE[2]} > ${TMPFILE[3]} #3 is db add
	while read INPUT; do
		if [[ "$INPUT" == "" ]]; then continue; fi
		PREFIX=$INPUT
		( process_output $2 $PREFIX &&\
		 ${RTBHDB} add $PREFIX Lists $NAME $DESC $EXPIRES )
	done <  ${TMPFILE[3]}
	comm -23 ${TMPFILE[1]} ${TMPFILE[2]} > ${TMPFILE[3]} #3 is leftover 1
	${RTBHDB} dump not active newer "1:week" format raw not text $NAME | sort | uniq > ${TMPFILE[1]}
	comm -12 ${TMPFILE[1]} ${TMPFILE[3]} > ${TMPFILE[2]} #2 is rtbh add	
	while read INPUT; do
		if [[ "$INPUT" == "" ]]; then continue; fi
		PREFIX=$INPUT
		( process_output $2 $PREFIX
		 ${RTBH} $PREFIX Lists $NAME $DESC $EXPIRES )
	done < ${TMPFILE[2]}
	if [[ -x `which ${RTBH_LISTS_EXTRA_ADD}` ]]; then
		${RTBHDB} dump not active newer "1:week" format raw text $NAME | sort | uniq > ${TMPFILE[1]}
		if [[ -r "$1" ]]; then 
			comm -12 ${TMPFILE[1]} ${TMPFILE[4]} > ${TMPFILE[2]} #2 is rtbh add	
		else
			cat ${TMPFILE[4]} | sort | uniq > ${TMPFILE[3]}
			comm -12 ${TMPFILE[1]} ${TMPFILE[3]} > ${TMPFILE[2]} #2 is rtbh add	
		fi
		EXTRA_INPUT=${TMPFILE[2]}
		while read PREFIX; do
			if [[ "$PREFIX" == "" ]]; then continue; fi
			( process_output $2 $PREFIX &&\
			 ${RTBH_LISTS_EXTRA_ADD} add $PREFIX Lists $EXTRA $NAME $DESC $EXPIRES )
		done < ${EXTRA_INPUT}
	fi
fi	

exit 0
