#!/bin/bash

which rtbh-lists-extra.sh >/dev/null  2>&1 || exit 1
NAME=${NAME:-"Cymru"}
RTBH_ROUTE=${RTBH_ROUTE:-"/usr/local/bin/rtbh-quagga-add-child-routes.sh"}
RTBH_SCREEN_OVERRIDE_BGP="${RTBH_SCREEN_OVERRIDE_BGP} ${NAME,,}"

cymru_process_input()
{

	local PREFIX
	local DESC
	local SUBN
	while read INPUT; do
		if [[ "$INPUT" == "" ]]; then continue; fi
		if [[ "${INPUT:0:1}" == "#" ]]; then continue; fi
		echo $INPUT
	done
}
INPUT_PROCESSOR="cymru_process_input"

cymru_process_output()
{
	unset EXPIRES
	unset EXTRA
	DESC="TeamCymru FullBogons drop list"
	return 0
}
OUTPUT_PROCESSOR="cymru_process_output"

. `which rtbh-lists-extra.sh`
