#!/bin/bash

which rtbh-lists-extra.sh >/dev/null  2>&1 || exit 1

dshield_process_input()
{

	local PREFIX
	local DESC
	local SUBN
	tail -n+2 | while read INPUT; do
		if [[ "$INPUT" == "" ]]; then continue; fi
		if [[ "${INPUT:0:1}" == "#" ]]; then continue; fi
		PREFIX="`echo $INPUT | cut -f1 -d' '`"
		SUBN="`echo $INPUT | cut -f3 -d' '`"
		echo "${PREFIX}/${SUBN}"
	done
}
INPUT_PROCESSOR="dshield_process_input"

dshield_process_output()
{
	test -n "$1" && test -r $1 || return 1
	test -n "$2" || return 1
	local NET=`echo $2 | cut -f1 -d'/' -s`
	test -n $NET || return 1
	local INPUT=`grep "^$NET" "$1"`
	local LDESC="`echo $INPUT | cut -f5 -d' '`"
	test -z "$LDESC" && return 0
	DESC="${LDESC%%,}"
	DESC="${DESC} `echo $INPUT | cut -f4 -d' '` attacks"
	unset EXPIRES
	unset EXTRA
	return 0
}
OUTPUT_PROCESSOR="dshield_process_output"

. `which rtbh-lists-extra.sh`
