#!/bin/bash

PATH=$PATH:/usr/local/bin:/usr/local/sbin
USER=autopilot
LISTDIR="/var/local/rtbh/lists/"

tmpNAME="${0##*-}"
tmpNAME="${tmpNAME%.sh}"
if [[ "$1" != "" ]]; then
	NAME=$1
fi
NAME=${NAME:-$tmpNAME}
LIST=${NAME,,}
if [[ "$2" != "" ]]; then
	LIST=$2
fi

UPDATES=`find  ${LISTDIR}/${LIST} -iname "update*"`
if [[ "$UPDATES" == "" ]] ; then exit; fi
#which rtbh-lists-${NAME,,}.sh || exit

updateForce=0
if [[ "$3" == "force" ]] || [[ "$RTBH_LIST_FORCE" != "" ]] ; then 
	updateParam="-f -s"
	updateForce="1"
fi
 
for i in $UPDATES; do
	which updateweb2local 2>&1 >/dev/null && updateweb2local $updateParam -i $i  2>&1 >/dev/null
	case $? in
		0) continue ;;
		1 | 10 | 11 | 101) (( $updateForce )) || continue  ;;
		2 | 3 | 4) continue ;; #update probably did not suceed, but state of update might be bad
		*) ;;
	esac
	RENICE=$((`curloadav`/3))
	((RENICE)) && renice +$((RENICE + `nice`)) $BASHPID
	( .  $i; test -x $CHK && $CHK ${CONF:-/dev/null} $TMP$FILE 2>&1 >/dev/null ) && continue
	( .  $i; which rtbh-lists-${NAME,,}.sh 2>&1 >/dev/null &&  rtbh-lists-${NAME,,}.sh ${CONF:-/dev/null} $TMP$FILE 2>&1 >/dev/null ) && continue
done
