#!/bin/bash

if [[ "$1" == "" ]]; then exit 1; fi

VTYSH_PROG=`which vtysh`
VTYSH_PAGER=more
LOGFACPRI=local5.info
LOGSTART=1
PATH="$PATH:`dirname $0`"
RTBH_RETRY="${RTBH_RETRY:-"5"}"
#strongly suggest starting any route-map with blackhole for other script compatibility
RTBH_ROUTE_MAPS[0]="${RTBH_ROUTE_MAP:-blackhole-nonchl}${RTBH_ROUTE_MAP_SUFFIX:+-${RTBH_ROUTE_MAP_SUFFIX}}"
RTBH_ROUTE_MAPS[1]="${RTBH_ROUTE_MAP:-blackhole-nonchl}"
RTBH_ROUTE_MAPS[2]="blackhole-nonchl"

if [[ "$VTYSH_PROG" == "" ]]; then exit 1; fi

unset SUBNETMASK
echo $1 | grep -q '/' 2>&1 >/dev/null && SUBNET="/`echo $1 | cut -f2 -d'/'`"
if [[ "$SUBNET" == "" ]]; then
	NETWORK=$1
	if [[ "$2" != "" ]]; then 
		SUBNET=" mask $2"
		SUBNETMASK="$SUBNET"
		((LOGSTART++))
	else
		SUBNET="/32"
	fi
else
	NETWORK="`echo $1 | cut -f1 -d'/'`"
fi

if [[ "$USER" == "autopilot" ]] && [[ "$SSH_CLIENT" != "" ]]; then 
	if [[ "$SUBNETMASK" != "" ]] && [[ "$SUBNET" != " mask 255.255.255.255" ]] ;  then
		echo "${NETWORK}${SUBNET} no rtbh $1 Subnet size error" >&2
		exit 1
	fi
	if [[ "$SUBNETMASK" == "" ]] && [[ "${SUBNET:1}" -le "24" ]]; then
		echo "${NETWORK}${SUBNET} no rtbh $1 Subnet size error" >&2
		exit 1
	fi
fi

unset TIMEOUT_CMD
unset ERROUTPUT
unset CHKFND
which timeout 2>&1 >/dev/null && TIMEOUT_CMD="timeout -k30 30"

CHKOUT=`which rtbh-quagga-chk-route.sh 2>&1 >/dev/null && rtbh-quagga-chk-route.sh ${NETWORK}${SUBNET}`
if [[ "$?" == 0 ]]; then
        if [[ "$CHKOUT" != "" ]]; then
                echo "$CHKOUT" | grep -q " ${NETWORK}${SUBNET}" && CHKFND="already "
        fi
fi


if [[ "$CHKFND" == "" ]]; then

	unset RTBH_ROUTE_MAP_STR
	for i in ${RTBH_ROUTE_MAPS[@]}; do
		echo "show route-map $i" | VTYSH_PAGER=more $TIMEOUT_CMD $VTYSH_PROG | grep -q "^\%.*not found$"
		if [[ "$?" == 1 ]]; then
			RTBH_ROUTE_MAP_STR="route-map $i"
			break;
		fi
	done	

	RTBH_RETRY="`printf %d $RTBH_RETRY`" || RTBH_RETRY="1"
	(( RTBH_RETRY > 0)) || RTBH_RETRY="1"
	COMMAND_STR="conf t\nrouter bgp 21719\nnetwork ${NETWORK}${SUBNET} ${RTBH_ROUTE_MAP_STR}\nend\nwri mem"
	for ((i=0;i<RTBH_RETRY;i++)); do
		OUTPUT=`echo -e $COMMAND_STR | VTYSH_PAGER=more $TIMEOUT_CMD $VTYSH_PROG `

		if [[ "$?" == "124" ]]; then
			ERROUTPUT="Timed out"
			if ((i+1 < RTBH_RETRY)); then continue; fi
		fi

		if [[ "$OUTPUT" != "" ]]; then
			ERROUTPUT1=`echo "$OUTPUT" | grep '^%'`
			if [[ "$ERROUTPUT" != "" ]]; then
				ERROUTPUT="$ERROUTPUT $ERROUTPUT1"
			else
				ERROUTPUT="$ERROUTPUT1"
			fi
			if (( i+1 < RTBH_RETRY )); then
				echo "$OUTPUT" | grep -q "^% Unknown command" && continue
			fi
		fi
		break
	done
fi

if [[ "$ERROUTPUT" != ""  ]]; then
	echo "${NETWORK}${SUBNET} no rtbh $1 $ERROUTPUT" >&2
	exit 1
else
	shift $LOGSTART
	if [[ "$SSH_CLIENT" != "" ]]; then
		USERFROM="@`echo $SSH_CLIENT | cut -f1 -d' '`"
	fi
	if [[ "$RTBH_DB" == "" ]] || [[ ! -x "`which $RTBH_DB`" ]]; then 
		which rtbh-db.sh > /dev/null && $TIMEOUT_CMD rtbh-db.sh add ${NETWORK}${SUBNET} $*
	elif [[ "$CHKFND" != "" ]]; then
		exit 0
	fi
	echo "${CHKFND}added ${NETWORK}${SUBNET} $*"
	if (which logger > /dev/null); then
		logger -p $LOGFACPRI -t `basename $0` -- $USER$USERFROM ${CHKFND}added ${NETWORK}${SUBNET} $*
	fi
fi


