#!/bin/bash

if [[ "$1" == "" ]]; then exit 1; fi

#Check if a route is already being blackholed

VTYSH_PROG=`which vtysh`

if [[ "$VTYSH_PROG" == "" ]]; then exit 1; fi

netmask_to_bits () { 
   c=0 x=0$( printf '%o' ${1//./ } )
   while [ $x -gt 0 ]; do
       let c+=$((x%2)) 'x>>=1'
   done
   echo $c ; 
}

for flag in ${RTBH_CHECK_FLAGS}; do
	case "${flag,,}" in
	localonly) RTBH_CHECK_LOCALONLY=1;;
	exact) RTBH_CHECK_EXACT=1;;
	longer) RTBH_CHECK_LONGER="longer prefixes";;
	*) ;;
	esac
done

verify_v4 () {

	local IFS="./"
	local i
	for i in $*; do
		case $i in
		(*[^0-9]*) return 1 ;;
		(*[0-9]*) (( i > 255)) && return 1;;
		esac
	done
	return 0
}

echo $1 | grep -q '/' 2>&1 >/dev/null && SUBNET="/`echo $1 | cut -f2 -d'/'`"
if [[ "$SUBNET" == "" ]]; then
        NETWORK=$1
        if [[ "$2" != "" ]]; then
                SUBNET=" mask $2"
		SUBNETBITS="`netmask_to_bits $2`"
        else
                SUBNET="/32"
		SUBNETBITS="32"
        fi
else
        NETWORK="`echo $1 | cut -f1 -d'/'`"
	SUBNETBITS="`echo $1 | cut -f2 -d'/'`"
fi

found_pref_bits()
{
	local IFS="./"
	local bits
	ADDR=($@)
	for i in 0 1 2 3; do
		[[ "${ADDR[$i]}" == "" ]] && return 1
		(( ${ADDR[$i]} < 255 )) || return 1
		[[ ${ADDR[$i]} -ge 0 ]] || return 1
	done
		
	if [[ "${ADDR[4]}" != "" ]]; then
		(( ${ADDR[4]} < 33 )) || return 1
		bits=${ADDR[4]}
	elif (( ADDR[0] < 128 )); then 
		bits="8"
	elif (( ADDR[0] < 192)); then
		bits="16"
	elif (( ADDR[0] < 224)); then
		bits="24"
	fi 
	echo ${ADDR[0]}.${ADDR[1]}.${ADDR[2]}.${ADDR[3]}/$bits
}


FOUND=0
if [[ "$RTBH_CHECK_EXACT" == "1" ]]; then 
	OUTPUT=`vtysh -c "show ip bgp ${NETWORK}/${SUBNETBITS} ${RTBH_CHECK_LONGER}"`
else
	OUTPUT=`vtysh -c "show ip bgp $1"`
fi

FOUNDPREF=`echo $OUTPUT | grep '^BGP routing table entry for' | cut -f6 -d' '`
if [[ "$FOUNDPREF" != "" ]]; then
	if [[ "$RTBH_CHECK_EXACT" != "1" ]]; then
		FOUND=1
	elif [[ "`found_pref_bits $FOUNDPREF`" == "`found_pref_bits ${NETWORK}/${SUBNETBITS}`"  ]]; then
		FOUND=1
	fi
fi

if [[ "$FOUND" == "1" ]]; then
	FOUND_COMMS=(`echo "$OUTPUT" | grep -E "^[[:space:]]+Community:" | cut -f2- -d:`)
	echo "$OUTPUT" | grep -q '^[[:space:]]*Local[[:space:]]*$' && FOUND_COMMS[${#FOUND_COMMS[@]}]="21719:400"

	for i in ${FOUND_COMMS[@]}; do
		case "$i" in
		
		21719:666)
			FOUNDrtbh=1
			;;
		21719:400)
			FOUNDlocal=1
			;;
		21719:4?3 | 21719:4?4 | 21719:4?5)
			#not a preferred route, probably going to add it
			FOUNDnonpref=1
			;;
		21719:43? | 21719:42? | 21719:41?)
			FOUNDpref=1
			;;
		21719:4*)
			#got an upstream/transit route, probably going to add it
			FOUNDtransit=1
			;;
		65332:888)
			FOUNDbogon=1
		esac
	done
else
	exit 1
fi

if [[ "$FOUNDrtbh" == "1" ]]; then
	if [[ "${RTBH_CHECK_LOCALONLY}" == "1" ]]; then
		if [[ "$FOUNDlocal" != "1" ]]; then exit 2; fi
		if [[ "$FOUNDbogon" == "1" ]]; then exit 3; fi
	fi
	echo $1 $FOUNDPREF
	exit 0
fi
exit 1
