#!/bin/bash


VTYSH_PROG=`which vtysh`
VTYSH_PAGER=more
LOGFACPRI=local5.info


if [[ "$VTYSH_PROG" == "" ]]; then exit 1; fi


COMMAND_STR="conf t\nrouter bgp 21719\n"

while read INPUT; do


TARGETARR=($INPUT)
if [[ "${TARGETARR[1]}" == "" ]]; then
	echo $INPUT | grep -q '/' 2>&1 >/dev/null && SUBNET="/`echo $INPUT | cut -f2 -d'/'`"
	if [[ "$SUBNET" == "" ]]; then
		SUBNET="/32"
	else
		NETWORK="`echo $INPUT | cut -f1 -d'/'`"
	fi
	if [[ "$NETWORK" != "" ]] && [[ "$SUBNET" != "" ]]; then
		TARGET="${NETWORK}${SUBNET}"
	else
		TARGET="$INPUT"
	fi
else
	TARGET="${TARGETARR[0]} mask ${TARGETARR[1]}"

fi

COMMAND_STR="${COMMAND_STR}no network ${TARGET}\n"

done

COMMAND_STR="${COMMAND_STR}end\nwri mem\nexit"


OUTPUT=`echo -e "$COMMAND_STR" | VTYSH_PAGER=more $VTYSH_PROG `

ERROUTPUT=`echo "$OUTPUT" | grep '^%'`

if [[ "$ERROUTPUT" != ""  ]]; then
        echo "something went wrong $ERROUTPUT" >&2
        exit 1
else
	if [[ "$SSH_CLIENT" != "" ]]; then
                USERFROM="@`echo $SSH_CLIENT | cut -f1 -d' '`"
        fi

        if (which logger > /dev/null); then

                logger -p $LOGFACPRI -t `basename $0` $USER$USERFROM removed routes $*
        fi
fi

