#!/bin/bash

RTBHDB=${RTBHDB:-"/usr/local/bin/rtbh-db.sh"}
RTBH_ADD=${RTBH:-"/usr/local/bin/rtbh-quagga-screen-add-route.sh"}
RTBH_DEL=${RTBH:-"/usr/local/bin/rtbh-quagga-del-route.sh"}
RTBH_LISTS=${RTBH_LISTS:-"/var/local/rtbh/lists/"}
VTYSH_CMD="vtysh"


test -x "${RTBHDB}"  || ( echo "Need RTBH database command" ; exit 1 )
test -x "${RTBH_ADD}" || ( echo "Need RTBH add command" ; exit 1 )
test -x "${RTBH_DEL}" || ( echo "Need RTBH del command" ; exit 1 )
test -x "`which $VTYSH_CMD 2>/dev/null`" || (echo "Need vtysh command" ; exit 1 )

. /usr/local/bin/rtbh-lists.func || exit

TMPS=6
for ((i=0;i<TMPS;i++)); do
	create_tmp || exit
done

$RTBHDB dump newer 16:days active format raw > ${TMPFILE[0]}
cat ${TMPFILE[0]} | sort | uniq > ${TMPFILE[1]}
cat ${TMPFILE[1]} > ${TMPFILE[0]}

$VTYSH_CMD -c "show ip bgp regexp ^$" | grep "^\*>" | cut -f2 -d' '  > ${TMPFILE[1]}
cat ${TMPFILE[1]} | grep "/"  > ${TMPFILE[2]}
cat ${TMPFILE[1]} | grep -v "^$" | grep -v "i" | grep -v "/" | while read PREFIX; do
	COMMENT="$PREFIX"
	echo "${PREFIX}/`v4class $PREFIX`"
done >> ${TMPFILE[2]}
cat ${TMPFILE[2]} | sort | uniq > ${TMPFILE[1]}

$VTYSH_CMD -c "show ip bgp community 21719:666" | grep "^\*>" | cut -f2 -d' '  > ${TMPFILE[2]}
cat ${TMPFILE[2]} | grep "/" > ${TMPFILE[3]}
cat ${TMPFILE[2]} | grep -v "^$" | grep -v "i" | grep -v "/" | while read PREFIX; do
	#echo "${PREFIX}/`ipcalc -c $PREFIX -n | grep Netmask | cut -f2 -d= | cut -f2 -d' '`"
	echo "${PREFIX}/`v4class $PREFIX`"
done >> ${TMPFILE[3]}
cat ${TMPFILE[3]} | sort | uniq > ${TMPFILE[2]}

comm -12 ${TMPFILE[1]} ${TMPFILE[2]} > ${TMPFILE[3]}

comm -13 ${TMPFILE[0]} ${TMPFILE[3]} > ${TMPFILE[4]} #delete
COMMENT="${TMPFILE[4]} has the deletes"
comm -23 ${TMPFILE[0]} ${TMPFILE[3]} > ${TMPFILE[5]} #add
comm -13 ${TMPFILE[2]} ${TMPFILE[5]} > ${TMPFILE[3]}
COMMENT="${TMPFILE[3]} has the adds"

echo "`wc -l ${TMPFILE[4]}` deletions to process" >&2
echo "`wc -l ${TMPFILE[3]}` additions to process" >&2

(while read PREFIX; do 

	(RTBH_DB=$RTBHDB $RTBH_DEL $PREFIX)
#	echo $PREFIX  | $RTBHDB routesynconly cat $RTBH_ADD $RTBH_DEL 
done < ${TMPFILE[4]})&
RTBH_FSYNC_DELPID=$!


(while read PREFIX; do 
	(RTBH_DB=$RTBHDB $RTBH_ADD $PREFIX)
#	echo $PREFIX  | $RTBHDB routesynconly cat $RTBH_ADD $RTBH_DEL 
done < ${TMPFILE[3]})&
RTBH_FSYNC_ADDPID=$!

wait $RTBH_FSYNC_DELPID $RTBH_FSYNC_ADDPID

exit 0
