#!/bin/bash

if [[ "$1" == "" ]]; then exit 1; fi

PATH=$PATH:/usr/local/sbin/
LOGFACPRI=local5.debug
LOGSTART=1
STATICFILTERS="/var/local/rtbh/static-filter-rtbh*"
PREFIXFILTERS="/var/local/rtbh/prefix-filters-rtbh*"
PREFIXMATCHCMD="/usr/local/bin/ip-prefix-match.sh"
RTBH_ADD_ROUTE="rtbh-quagga-add-route.sh"

which ${RTBH_ADD_ROUTE} 2>&1 >/dev/null || (  echo "no rtbh add route cmd"; exit 1 )

RTBH_SCREEN_OVERRIDE_BGP="${RTBH_SCREEN_OVERRIDE_BGP} dshield spamhaus child"

netmask_to_bits () { 
   c=0 x=0$( printf '%o' ${1//./ } )
   while [ $x -gt 0 ]; do
       let c+=$((x%2)) 'x>>=1'
   done
   echo $c ; 
}

verify_v4 () {

	local IFS="./"
	local i
	for i in $*; do
		case $i in
		(*[^0-9]*) return 1 ;;
		(*[0-9]*) (( i > 255)) && return 1;;
		esac
	done
	return 0
}

echo $1 | grep -q '/' 2>&1 >/dev/null && SUBNET="/`echo $1 | cut -f2 -d'/'`"
if [[ "$SUBNET" == "" ]]; then
        NETWORK=$1
        if [[ "$2" != "" ]]; then
                SUBNET=" mask $2"
		SUBNETBITS="`netmask_to_bits $2`"
        else
                SUBNET="/32"
		SUBNETBITS="32"
        fi
else
        NETWORK="`echo $1 | cut -f1 -d'/'`"
	SUBNETBITS="`echo $1 | cut -f2 -d'/'`"
fi

found_pref_bits()
{
	local IFS="./"
	local bits
	ADDR=($@)
	if [[ "${ADDR[4]}" != "" ]]; then
		bits=${ADDR[4]}
	elif (( ADDR[0] < 128 )); then 
		bits="8"
	elif (( ADDR[0] < 192)); then
		bits="16"
	elif (( ADDR[0] < 224)); then
		bits="24"
	fi 
	echo ${ADDR[0]}.${ADDR[1]}.${ADDR[2]}.${ADDR[3]}/$bits
}

rtbh_screen_override()
{
	local Name
	local Names
	local Arg
	while read Names; do 
		for Name in $Names; do
			for Arg in $*; do
				if [[ "${Arg,,}" == "${Name,,}" ]]; then return 0; fi
			done
		done	
	done	
	return 1
}

#bgp screening
VTYSH_PROG=`which vtysh`

if [[ "$VTYSH_PROG" == "" ]]; then exit 1; fi

unset TIMEOUTCMD
which timeout 2>&1 >/dev/null && TIMEOUT_CMD="timeout -k30 30"

verify_v4 $NETWORK || exit

for fNET in "$NETWORK" "${NETWORK}/${SUBNETBITS}"; do
	OUTPUT=`vtysh -c "show ip bgp $fNET"`
	FOUNDPREF=`echo "$OUTPUT" | grep '^BGP routing table entry for' | cut -f6 -d' '`
	echo "$FOUNDPREF" | grep -q "/" || FOUNDPREF=`found_pref_bits $FOUNDPREF`
	if [[ "$FOUNDPREF" == "" ]]; then continue; fi
	FOUND_COMMS=(`echo "$OUTPUT" | grep -E "^[[:space:]]+Community:" | cut -f2- -d:`)
	echo "$OUTPUT" | grep -q "^[[:space:]]\*+Local[[:space:]]\*$" && FOUND_COMMS[${#FOUND_COMMS[@]}]="21719:400"

	for i in ${FOUND_COMMS[@]}; do
		case "$i" in
		
		21719:666)
			if [[ "${NETWORK}/${SUBNETBITS}" == "${FOUNDPREF}" ]]; then 
				if [[ "$RTBH_DB" == "" ]] || [[ ! -x "`which $RTBH_DB`" ]]; then
					which rtbh-db.sh 2>&1 >/dev/null && $TIMEOUT_CMD rtbh-db.sh refresh ${NETWORK}${SUBNET} $*
				fi
			
				#not an error
				echo "$NETWORK rtbh $FOUNDPREF" 
			else
				#Covering route is blackholed, add anyways?
				continue
			fi
			exit 0
			;;
		21719:400)
			echo "$NETWORK failed found bgp $FOUNDPREF" >&2
			logger -p $LOGFACPRI -t `basename $0` $USER$USERFROM failed found bgp $FOUNDPREF ${NETWORK}${SUBNET} $*
			exit 10
			;;
		21719:4?3 | 21719:4?4 | 21719:4?5)
			#not a preferred route, probably going to add it
			;;
		21719:43? | 21719:42? | 21719:41?)
			if [[ "${NETWORK}/${SUBNETBITS}" != "${FOUNDPREF}" ]]; then continue; fi
			echo ${RTBH_SCREEN_OVERRIDE_BGP} | rtbh_screen_override $* && continue
			echo "$NETWORK failed found bgp $FOUNDPREF community $i" >&2
			logger -p $LOGFACPRI -t `basename $0` $USER$USERFROM failed found bgp $FOUNDPREF community $i ${NETWORK}${SUBNET} $*
			exit 10
			;;
		21719:4*)
			#got an upstream/transit route, probably going to add it
			;;
		esac
	done
done


#dynip screening
if (which dig 2>&1 >/dev/null); then 

	REVNET=`echo "$NETWORK" | ( IFS='.' read a b c d; echo "$d.$c.$b.$a" )`
	dynip=`dig +short in ptr $REVNET.in-addr.dynamic.chl.net`
	if (echo $dynip | grep -q "dynamic.chl.net"); then
		echo "$NETWORK failed found $dynip" >&2
		logger -p $LOGFACPRI -t `basename $0` $USER$USERFROM failed found $dynip ${NETWORK}${SUBNET} $*
		exit 11
	fi
#pswl screening 
	pswl=`dig +short $REVNET.pswl.ttec.net`
	if (echo $pswl | grep -q "127.0.0.10"); then 
		echo "$NETWORK failed found $REVNET.pswl.ttec.net" >&2
		logger -p $LOGFACPRI -t `basename $0` $USER$USERFROM failed found $REVNET.pswl.ttec.net ${NETWORK}${SUBNET} $*
		exit 12
	fi

else
	echo "$NETWORK no dig" >&2
fi

#static screening

REVERSE=`dig +short -x $NETWORK`
if [[ "$REVERSE" == "" ]]; then
	unset REVERSE
elif [[ "$REVERSE" == "." ]]; then
	unset REVERSE
elif [[ "${REVERSE#*.}" == "" ]]; then
	unset REVERSE
fi
for i in ${STATICFILTERS}; do
	test -r $i || continue;
	if (grep -q "^${NETWORK}" $i); then
		echo "$NETWORK failed found static filter $i" >&2
		logger -p $LOGFACPRI -t `basename $0` $USER$USERFROM failed found static filter ${NETWORK}${SUBNET} $*
		exit 13
	fi
	if [[ "$REVERSE" != "" ]] && (grep -q "^${REVERSE: : -1}$" $i); then
		echo "$NETWORK failed found reverse static filter ${REVERSE: : -1 }" >&2
		logger -p $LOGFACPRI -t `basename $0` $USER$USERFROM failed found reverse ${REVERSE: : -1 } static filter ${NETWORK}${SUBNET} $*
		exit 14
	fi
done

for i in ${PREFIXFILTERS}; do
	test -x $PREFIXMATCHCMD || break
	test -r $i || continue;
	while read INPUT CMNT; do
		if [[ "$INPUT" == "" ]]; then  continue; fi
		if [[ "${INPUT:0:1}" == "#" ]]; then  continue; fi
		verify_v4 $INPUT || INPUT=`(which dig 2> /dev/null 1>&2 && dig +short $INPUT | grep -Eo "[0-9]+\.[0-9]+\.[0-9]+\.[0-9]+")` &&\
		verify_v4 $INPUT || continue
		if [[ "$SUBNETBITS" == "32" ]]; then
			$PREFIXMATCHCMD ${NETWORK}/${SUBNETBITS} $INPUT || continue
		else
			($PREFIXMATCHCMD $INPUT ${NETWORK}/${SUBNETBITS} ||\
			$PREFIXMATCHCMD ${NETWORK}/${SUBNETBITS} $INPUT) || continue
		fi
		echo "$NETWORK failed found prefix filter $i $INPUT $CMNT" >&2
		logger -p $LOGFACPRI -t `basename $0` $USER$USERFROM failed found prefix filter $CMNT ${NETWORK}${SUBNET} $*
		exit 15
	done < $i
done
	
		
if [[ "${FOUND}" == "1" ]]; then exit 19; fi

if [[ "$RTBH_TEST" != "" ]]; then exit 0; fi
#execute rtbh
for ((i=0;i<5;i++)); do
	OUTPUT="`$RTBH_ADD_ROUTE $@ 2>&1`"
	if [[ "$?" == "0" ]]; then
		echo "$OUTPUT"
		exit 0
	fi
	echo "$OUTPUT" | grep -q "% Unknown command" || break
done

echo "$OUTPUT"
echo "$NETWORK no rtbh" >&2 
exit 1
