/*

By accepting this notice, you agree to be bound by the following
agreements:

This software product, printline , is copyrighted (C) 2005 by
Josef Maimon, New York, New York, USA,  with all rights reserved.

This program is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License (version 2) as
published by the Free Software Foundation.  It is distributed in the
hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License (GPL) for more details.

You should have received a copy of the GNU General Public License
(GPL) along with this program.

*/

/* Todo
 
   multiple instances of arguments (llist library)

   long options

   regular expressions
   
   line ranges

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <libgen.h>
#include <unistd.h>
#include <ctype.h>



void usage(void);
void print_version(void);
void convert_escape(char *);
size_t reverse_fwrite( const void *ptr, size_t size, size_t nmemb, FILE *stream);
ssize_t printline_getdelim(char **, size_t *, int, char*, size_t, FILE *); 
void * printline_memmem(void *, size_t, void *, size_t, size_t *);
void reverse_buf(char *, size_t);

char * ProgName;
int binary_mode = 0;

#ifndef MAX_BUF
	#define MAX_BUF 4096
#endif /* MAX_BUF */

int
main(int argc,char **argv){

	char * buffer = NULL;
	ssize_t size;
	ssize_t offset = 0;
	unsigned readlinenum = 0;
	int i = 0, ch = 0, haveinfile = 0 , haveoutfile = 0, havereadlinenum = 0;
	int ret = 0;
	unsigned maxreadlinenum = 0, havemaxreadlinenum = 0, minreadlinenum = 0, haveminreadlinenum = 0;
	FILE * outfile = NULL, * infile = NULL;
	int printed_anything = 0;
	char * delim = "";
	int delimlen = 0;
	int delimnewline = 1;
	int delimspace = 0;
	int trimdelim = 0;
	char * trimdelimch = NULL;
	int trimdelimlen = 0;
	char * delimspacech = NULL;
	int delimspacechlen = 0;
	size_t bytes_read = 0;
	size_t bytes_written = 0;
	char *addchar = "";
	int addcharlen = 0;
	int haveaddchar = 0;
	int addcharnum = 0;
	int haveaddcharnum = 0;
	char * addchardelim = NULL;
	int addchardelimlen = 0;
	size_t (*printline_fwrite) (const void*, size_t, size_t, FILE *) = fwrite;
	int reverse_input = 0;
	char *pattern = NULL;
	int patternlen = 0;
	char *ipattern = NULL;
	int ipatternlen = 0;
	int Earg_ind = 0;
	int Oarg_ind = 0;
	
	ProgName = argv[0];
	
	while ((ch = getopt(argc, argv, "A:a:bErRsS:tT:d:m:x:Nn:i:o:p:P:h?v")) != EOF)
		switch(ch)
		{
			case 'E':
				Earg_ind = optind;
				break;
			case 'A':
				addcharnum = atoi(optarg);
				if (addcharnum)
					haveaddcharnum = 1;
				else
				{
					addchardelim = optarg;
					convert_escape(addchardelim);
					addchardelimlen = strlen(addchardelim);
				}
				break;
			case 'a':
				addchar = optarg;
				convert_escape(addchar);
				haveaddchar++;
				addcharlen = strlen(addchar);
				break;
			case 'b':
				binary_mode = 1;
				break;
			case 'N':
				delimnewline = 0;
				break;
			case 'T':
				trimdelimch = optarg;
				convert_escape(trimdelimch);
				trimdelimlen = strlen(trimdelimch);
				/*fall-through*/
			case 't':
				trimdelim = 1;
				break;
			case 'r':
				printline_fwrite = reverse_fwrite;
				break;
			case 'R':
				reverse_input = 1;
				break;
			case 'S':
				delimspacech = optarg;
				convert_escape(delimspacech);
				delimspacechlen = strlen(delimspacech);
				reverse_buf(delimspacech,delimspacechlen);
				/*fall-through*/
			case 's':
				delimspace =1;
				break;
			case 'd':
				delim = optarg;
				convert_escape(delim);
				delimlen = strlen(delim);
				break;
			case 'i':
				infile = fopen(optarg,"r");
				if(!infile)
				{
					perror("Could not open file");
					exit(1);
				}
				haveinfile = 1;
				break;
			case 'o':
				outfile = fopen(optarg,"w");
				if(!outfile)
				{
					perror("Could not open file");
					exit(1);
				}
				haveoutfile = 1;
				break;
			case '0':
				Oarg_ind = optind;
				break;
			case 'n':
				readlinenum = atoi(optarg);	
				havereadlinenum = 1;
				break;
			case 'p':
				pattern = optarg;
				convert_escape(pattern);
				patternlen = strlen(pattern);
				break;
			case 'P':
				ipattern = optarg;
				convert_escape(ipattern);
				ipatternlen = strlen(ipattern);
				break;
			case 'x':
				maxreadlinenum = atoi(optarg);
				havemaxreadlinenum = 1;
				break;
			case 'm':
				minreadlinenum = atoi(optarg);
				haveminreadlinenum = 1;
				break;
			case 'v':
				print_version();
			case 'h':
				/* Fall through */
			case '?':
				/* Fall through */
			default:
				usage();
			
			
		}

	if(binary_mode)
		setbuf(stdout, NULL);	

	buffer = malloc(BUFSIZ);
	if(buffer)
		size = BUFSIZ;

	if(!haveinfile)
		infile = stdin;
	if(!haveoutfile)
		outfile = stdout;
	
	if(!havereadlinenum)	
		if (argc > 1 && optind < argc)
			havereadlinenum = (readlinenum = atoi(argv[optind]));
			
	if (!havereadlinenum && !havemaxreadlinenum && !haveminreadlinenum && 
			!delimlen && !trimdelim && !delimspace && !haveaddchar &&
		       	!reverse_input && !patternlen && !ipatternlen)
			goto shorter_circuit;
	
	ret = 2;
	while( -1 != (bytes_read = printline_getdelim(&buffer,&size,1, (delimlen ? delim : "\n"),
					(delimlen ? delimlen : 1), infile)) )
	{
		if (bytes_read == 1 && *buffer == '\0' && feof(infile) && 
			(!delimlen || '\0' != *delim) && !binary_mode)
			break;

		bytes_written = 0;

		if(reverse_input)
			reverse_buf(buffer,bytes_read);

		offset = 0;
		i++;

		if (!havereadlinenum && !havemaxreadlinenum && !haveminreadlinenum)
				goto short_circuit;

		if((!trimdelim && !delimspace && !haveaddchar && !reverse_input &&
			!patternlen && !ipatternlen ) && 
			!readlinenum && !maxreadlinenum && minreadlinenum && i >= minreadlinenum)
		{	/* shortcut */
		shorter_circuit:
			while(!feof(infile) && 
				(bytes_read = fread(buffer,1,(size >= BUFSIZ) ? BUFSIZ : size ,infile))>0)
				while(!feof(outfile) &&
				      (bytes_written = printline_fwrite(buffer,1,bytes_read,outfile)) && 
				      (bytes_read -= bytes_written));
			exit(0);
		}
		
		if( (!readlinenum || i > readlinenum) &&
		    (!maxreadlinenum || i > maxreadlinenum) &&
		    (!minreadlinenum)
		  )
			exit(printed_anything ? 0 : 1);
		else if( i == readlinenum || 
			  (maxreadlinenum &&  minreadlinenum && i <= maxreadlinenum  && i >= minreadlinenum) ||
			  (minreadlinenum && !maxreadlinenum && i >= minreadlinenum) ||
			  (maxreadlinenum && !minreadlinenum && i <= maxreadlinenum)
			)
		{	
		short_circuit:
			if (patternlen &&	
				!printline_memmem(pattern, patternlen, buffer, bytes_read, NULL))
					continue;
			
			if (ipatternlen &&	
				printline_memmem(ipattern, ipatternlen, buffer, bytes_read, NULL))
					continue;
				
			printed_anything = 1;

			if (delimspace)
			{
				int i = 2;

				if (delimspacech)
				{
					char * buf_delim = NULL;

					reverse_buf(buffer, bytes_read);
					buf_delim = printline_memmem(delimspacech, delimspacechlen, 
							buffer, bytes_read, NULL);
					if(buf_delim)
					{
						offset = (buf_delim - buffer);
						offset = bytes_read - offset - 1;
					}
					reverse_buf(buffer, bytes_read);
				}
				else
				{
					while(!isspace(*(buffer+bytes_read-i)) && i < bytes_read)
						i++;
					if (i != bytes_read)
						offset = bytes_read - i + 1;	
				}
			}
			
			if (trimdelim)
			{
				int i = 0;

				if (trimdelimch)
				{
					char * buf_delim = printline_memmem(trimdelimch, trimdelimlen, 
							buffer, bytes_read, NULL);
					if(buf_delim)
						offset = buf_delim - buffer;
				}
				else
				{
					while(isspace(*(buffer+i)) && i < bytes_read)
						i++;
					offset = i;
				}	
			}

			if (delimlen && *delim != '\n' && delimnewline)
				if (buffer[bytes_read-1] == *delim)
					buffer[bytes_read-1] = '\n';
			if(!haveaddchar)	
				printline_fwrite(buffer+offset,1,bytes_read-offset,outfile);
			else if (haveaddcharnum || addchardelim)
			{
				char * tdelim = (delimlen) ? delim : "\n";
				int tdelimlen = (delimlen) ? delimlen : 1;
				char  * buf_delim = NULL;

				if(haveaddcharnum)
				{
					while(bytes_written < bytes_read)
					{
						int i = 0;
						bytes_written += printline_fwrite(buffer+offset+bytes_written,
								1,addcharnum,outfile);
						if(bytes_read > bytes_written && 
						  ((haveaddchar > 1) || 
						   !printline_memmem(tdelim,tdelimlen,
							   buffer+offset+bytes_written - tdelimlen, tdelimlen, NULL)))
							printline_fwrite(addchar,1,addcharlen,outfile);
					}	
				}
				else
				{
					while(bytes_written < bytes_read)
					{
						int i = 0;

						buf_delim = printline_memmem(addchardelim, addchardelimlen, 
								buffer+offset+bytes_written, 
								bytes_read - offset - bytes_written, NULL);
						bytes_written += printline_fwrite(buffer+offset+bytes_written,1,
						(buf_delim) ? buf_delim - (buffer+bytes_written) + addchardelimlen : 
						bytes_read - bytes_written,
						outfile);

						if(buf_delim &&
						   bytes_read > bytes_written && 
						  ((haveaddchar > 1) || 
						   !printline_memmem(tdelim,tdelimlen,
							buffer+offset+bytes_written, tdelimlen, NULL)))
							printline_fwrite(addchar,1,addcharlen,outfile);
					}
				}
			}
		}
		else if(havemaxreadlinenum && i > maxreadlinenum)
			break;
	}
	exit(printed_anything ? 0 : 1);
	return (0);	
}



void 
usage(void){

	fprintf(stderr,"Usage: %s [-a append] [-A numchars | -A delim] [-b] [-rR] [-st] [-S spacechars] [-T spacechars] [-d delim] [-N] [-n lineno] [-m minlineno] [-x maxlineno] [-i infile] [-o outfile] [-p string] [-P string] [-v] [-?h]\n",basename(ProgName));
	fprintf(stderr,
	"OR\n"
	"Usage: %s N , where n is the number line to print from stdin\n",basename(ProgName));	
	fprintf(stderr,
	"\n"
	"-a appendstr   : append this charachter/string every -A\n"
	"-A num|delim   : either number of charachters or a delimiter\n"
	"-a appendstr   : repeat the -a for appendation to occur even at newline or -d'delim'\n"
	"-b             : err on the side of non textual, binary behavior\n"
	"-r             : reverse our input\n"
	"-R             : reverse our output. Contrast with -r. May be used together with -r.\n"
	"-s             : print from first space before delimiter\n"
	"-S             : list of charachters to use for -s instead of whitespace\n"
	"-t             : trim leading spaces\n"
	"-T             : list of charachters to use for -t instead of whitespace\n"
	"-d delim       : a delimiter string or charachter\n"
	"-n lineno      : Number line to be printed. Must be positive\n"
	"-N             : dont convert non newline delimiter char to newline\n"
	"-x maxlineno   : To number line to be printed. Must be positive\n"
	"-m minlinno    : From number line to be printed. Must be positive\n"
	"-i infile      : File to process as input. Defaults to stdin\n"
	"-o outfile     : File to send output. Defaults to stdout\n"
	"-p string      : print delimited text/lines matching string\n"
	"-P string      : print delimited text/lines NOT matching string\n"
	"-v             : Prints the version and exits\n"
	"-h -?          : This message\n"
	"\n"
	"Line number may also be set by the first non option style argument\n"
	"If there is no line number specified, %s will print all its input\n",basename(ProgName));
	fprintf(stderr,
	"To convert the delim charachter to anything other than newline, see tr(1)\n"
	"\n"
	"Escape sequences are supported as in echo(1)\n"
	       );
	exit(1);
	
	
}

void
print_version(void){
	fprintf(stderr,"%s: Version 0.14 Copyright 2005 Joe Maimon. This program is licensed under the GNU GPL v2\n",basename(ProgName));
	usage();
}

/* copied from Debian GNU/Linux echo */
void
convert_escape(char *s)
{
	register char *s1 = s;
	char c;

	while ((c = *s++))
	{
		if (c == '\\' && *s)
		{
			switch (c = *s++)
			{
				case 'a': c = '\007'; break;
				case 'b': c = '\b'; break;
				case 'f': c = '\f'; break;
				case 'n': c = '\n'; break;
				case 'r': c = '\r'; break;
				case 't': c = '\t'; break;
				case 'v': c = (int) 0x0B; break;
				case '0': case '1': case '2': case '3':
				case '4': case '5': case '6': case '7':
				c -= '0';
				if (*s >= '0' && *s <= '7')
					c = c * 8 + (*s++ - '0');
				if (*s >= '0' && *s <= '7')
					c = c * 8 + (*s++ - '0');
				break;
				case '\\': break;
				default: ; break;
			}
		}
		*s1++ = c;
	}
	*s1 = '\0';
}


size_t reverse_fwrite( const void *ptr, size_t size, size_t nmemb, FILE *stream)
{

	size_t ptr_len = (size * nmemb);
	size_t ptr_len2;
	const char * src = ptr;
	char * buf = malloc(size * nmemb);
	size_t i = 0;
	size_t ret = 0;

	if(!buf)
		return 0;

	/* off-by-one*/
	ptr_len--;
	
	if(ptr && ptr_len && !(ptr_len > (size * nmemb)) )
	{
		/*
		 * string handling
		 */
		if(!binary_mode)
		{
			if(*(src+ptr_len) == '\0')
				*(buf+ptr_len) = *(src+ptr_len--);
			if(*(src+ptr_len) == '\n')
				*(buf+ptr_len) = *(src+ptr_len--);
		}

		ptr_len2 = ptr_len;

		if(ptr_len <= (size * nmemb))
			for(i=0; i <= ptr_len2; ) 
				*(buf+i++) = *(src+ptr_len--); 
	}

	ret = fwrite(buf, size, nmemb, stream);
	
	free(buf);
	return(ret);
}	

/* does not require memory allocation*/
void reverse_buf(char * ptr, size_t size)
{
	char c;
	size_t i; 
	size_t len = size;
	size_t len2;

	if(!ptr || !(size > 0))
	       return;	
	/* off-by-one*/
	len--;

	/*
	 * string handling
	 */
	if(!binary_mode)
	{
		if(*(ptr+len) == '\0')
			len--;
		if(*(ptr+len) == '\n')
			len--;
	}

	len2 = len;

	if(len > size)
		return;

	for(i = 0; i <= len && len <= len2 ; i++, len--)
	{
		c = (char)*(ptr+len);
		(char) *(ptr+len) = (char) *(ptr+i);
		(char) *(ptr+i) = c;
	}	
}

/* modeled after gnu getdelim() this version works with either caller owened 
 * memory or self owned memory
 *
 * More importantly, a delimeter can be a string.
 *
 * Set aflag to > 0 if you wish memory to be handled by self
 *
 */
ssize_t printline_getdelim(char **buf, size_t *n, int aflag, char *delim, size_t delim_len, FILE *stream) 
{
	size_t len;
	char *lbuf;
	char *lbuf2;
	size_t bytes_read = 0;
	size_t ret = 0;
	int eof_f = 0;
	size_t mtch = 0;

	if(!buf || !stream)
		return -1;

	if(!aflag && (!buf || !*buf || !n || !*n) )
		return -1;

	if(n)
		len = *n;

	if(aflag && !*buf)
	{
		len = MAX_BUF;
		lbuf = malloc(len);
	}
	else if(aflag && buf && !len)
	{
		len = MAX_BUF;
		lbuf = realloc(*buf, len);
	}
	else if(aflag)
		lbuf = *buf;
	else if(!aflag)
		lbuf = *buf;

	if(!lbuf)
		return -1;

	while (1)
	{
		char * delim_buf = NULL;
		
		if(feof(stream) || ferror(stream))	
		{
			eof_f = 1;
			break;
		}
		
		if(len - bytes_read == 0 || len - bytes_read > len) 
		{
			if (!aflag)
				break;
			else
				len *= 2;

			lbuf2 = realloc(lbuf, len);
			if (!lbuf2)
				break;
			else
				lbuf = lbuf2;
		}
		/* carefull never to read past a possible delimiter */
		/* otherwise we have to store it somewhere....*/
		ret = fread(lbuf+bytes_read,1,(delim_len && (delim_len - mtch) < (len - bytes_read) ? 
					delim_len - mtch : len - bytes_read), stream);
		
		if(ret && delim_len && delim)
		{
			size_t offset = ((bytes_read >= delim_len) ? bytes_read - delim_len : 0);
			delim_buf = printline_memmem(delim, delim_len, lbuf+offset, bytes_read + ret - offset, &mtch); 
		}

		if(delim_buf)
		{
			bytes_read = delim_buf - lbuf + delim_len;
			break;
		}
		
		bytes_read += ret;

	}

	if(aflag)
	{
		*buf = lbuf;
		if(n)
			*n = len;
	}
	if(!bytes_read && eof_f)
		return -1;
	else
		return(bytes_read);	
}
/*
 * Locate needle in haystack
 *
 * Params:
 *  needle
 *  needle's length
 *  haystack
 *  haystack's length
 *  (optional) address of variable to store how many charachters matched
 *      saved here will be the number of bytes of needle that matched
 *      at the point that hlen is reached. May be zero. Will never be >nlen.
 *      Will always be zero if return is not NULL.
 *
 *	Use this to tell you how many more charachters to read.
 *
 *	If you always read no more (nlen - pmtch) and haystack 
 *	begins with the last (nlen - pmtch) of the previous call,
 *	you will never read past match.
 *
 *	Any other implementation requires storing the leftover read 
 *	after match in either a static buffer or passed between caller and
 *	function
 */ 

void * printline_memmem(void * needle, size_t nlen, void * haystack, size_t hlen, size_t *pmtch)
{
	register size_t i = 0,j = 0;
	register char * s = haystack;
	register char * n = needle;

	if(!needle || !nlen)
		return haystack;
	if(!haystack || !hlen)
		return NULL;
	
	while(j+i < hlen)
	{
		i=0;

		while( i < nlen && j+i <hlen && (*(s+j+i)) == (*(n+i)) )
			i++;

		if(i == nlen)
			return haystack + j;
		j++;
	}
	if(pmtch)
		*pmtch = i;
		
	return NULL;
}


