#!/bin/bash

if (($# < 1)); then
	echo "Usage: `basename $0` \"sendmail queue or data file, not both\"" >/dev/stderr
	exit 1
fi

for i in cut grep printline cat; do
	if  ! which "$i" >/dev/null 2>&1; then
		echo "Cannot find $i" >/dev/stderr
		exit 1
	fi
done
	

i=`basename $1`
j=`dirname $1`

if [[ $j == "" ]]; then j='./'; fi

queuefile="${j}/q${i:1}"
dueuefile="${j}/d${i:1}"
Queuefile="${j}/Q${i:1}"
Dueuefile="${j}/D${i:1}"

qfile=""
dfile=""



if [[ -f "$queuefile" ]] ; then 
	qfile="$queuefile"
elif [[ -f "$Queuefile" ]]; then
	qfile="$Queuefile"
fi

if [[ -f "$dueuefile" ]] ; then 
	dfile="$dueuefile"
elif [[ -f "$Dueuefile" ]]; then
	dfile="$Dueuefile"
fi

if [[ "$qfile" == "" || "$dfile" == "" ]]; then
	echo "Cannot find queue and data file for $1" > /dev/stderr
	exit 1
fi



sender_addr=`cat $qfile | grep '^S'`
return_path="Return-Path: ${sender_addr:1}"

echo "From ${sender_addr:1} `date`"
echo "$return_path"


inheader="n"
while(true) ; do

	((LINE++))

	lineinput=`printline $LINE < $qfile`

	if (( $? > 0 )); then
		break;
	fi


	if [[ "${lineinput:0:2}" == "H?" ]] && [[ "${lineinput:0:16}" != "H?P?Return-Path:" ]]; then
		inheader="y"
		echo "$lineinput" | cut -f3 -d'?'
		continue
	fi

	if [[ "${inheader}" == "y" ]]; then 
		echo "$lineinput" | grep '^[[:space:]]' || inheader="n"
	fi

 done 

echo ""
cat $dfile
echo ""

