#!/bin/bash

PATH="${PATH}:`pwd`"

if (( "$#" < 2 )); then
	echo "Usage: `basename $0` \"sendmail-qdir\" \"out-mbox\"" > /dev/stderr
	exit 1
fi

if ! [[ -d "$1" ]]; then
	echo "$1 is not a directory" > /dev/stderr
	exit 1
fi

for i in cygfind sendmail-2-mbox.sh; do
	if  ! which "$i" >/dev/null 2>&1; then
	echo "Cannot find $i" >/dev/stderr
	exit 1
	fi
done

cygfind "$1"  -name 'q*' -exec sendmail-2-mbox.sh \{\} >> $2 \;

