#define _GNU_SOURCE
#include <stddef.h>
#include <errno.h>
#include <stdlib.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <unistd.h>
#include <fcntl.h>


/*
 * TODO:
 * Use select or poll on read.
 *
 * Accept arguments, particulary what to do with input newlines
 */

int connect2sock(char * filename);
int socktelnet(int sock_no);

int main(int argc, char ** argv)
{
	int sock_no = 0;
	int ret = 0;
	
	if(argc < 2)
		exit(1);

	sock_no = connect2sock(argv[1]);

	if(sock_no <= 0)
		exit(1);

	setbuf(stdout,NULL);
	setbuf(stdin,NULL);


	ret = socktelnet(sock_no);
	
	shutdown(sock_no,2);
	return(ret);
}

int connect2sock(char * filename)
{
	int sock_no = 0;	

	struct sockaddr_un server;

	memset((char *)&server, 0, sizeof(struct sockaddr_un));
	server.sun_family = AF_UNIX;
	strncpy(server.sun_path, filename, sizeof(server.sun_path));

	if((sock_no = socket(AF_UNIX, SOCK_STREAM, 0)) < 0) 
	{
		perror("socket");
		return 0;
	}
	if(connect(sock_no, (struct sockaddr *)&server, sizeof(struct sockaddr_un)) < 0) 
	{
		perror("sock_no");
		return 0;
	}
	return sock_no; 
}

int socktelnet(int sock_no)
{
	size_t ret_size = 0;
	char * buf = NULL;
	size_t size = 0;
	char read_buf[1024];
	int read_bytes = 0;


	fcntl(sock_no,F_SETFL,O_NONBLOCK);

	while(1)
	{
		int i = 0;
#ifdef DEBUG
			fprintf(stderr,"in getline loop\nbuf is %s\n",buf);
#endif
		if(-1 == (ret_size = getline(&buf,&size,stdin)))
			break;
	
			
		if(write(sock_no, buf, strlen(buf))<0)	
			return(1);
		while(1)
		{
			i++;
#ifdef DEBUG
			fprintf(stderr,"in read loop\n");
#endif
			read_bytes = read(sock_no, read_buf, sizeof(read_buf)-1);
			if(read_bytes < 0)
			{
				if(errno == EAGAIN || errno == EINTR)
				{
					if(i<5)
					{
						sleep(1);
						continue;
					}
					else
					{
						break;
					}
				}
#ifdef DEBUG
				perror("read:");
#endif
				return(1);
			}
			if(!read_bytes)
				break;
#ifdef DEBUG
			fprintf(stderr,"read_buf is %s\n", read_buf);
#endif
		
			if(read_buf[read_bytes - 1] == '\n')
				read_buf[read_bytes - 1] = '\0';	
			else
				read_buf[read_bytes] = '\0';
			puts(read_buf);
		}
	
	}	
	return(0);
}
