#include "llist.h"
#include "llist_error.h"

struct llist_error_FLAGS llist_error_flags = { 0,0,0,0 };

static unsigned int
llist_error_index(unsigned int);

static void
llist_error_action(unsigned int,const char *);

static void
llist_error_perror_arg(unsigned int, const char *);

static unsigned int
llist_error_get(void);

static struct llist_error llist_error_table [] =
{ 
	{ LLIST_ERROR_EGIGO , "garbage in, garbage out" , 0 },
	{ LLIST_ERROR_EDELE , "deletion routine reaached impossible code branch", 1}

};

static unsigned int llist_errno = 0;

static unsigned int 
llist_error_index(unsigned int ui)
{
	int i = 0;
	
	while(i < sizeof(llist_error_table)/sizeof(llist_error_table[0]) )
	{
		if(llist_error_table[i].llist_errno == ui)
			return(i);

		i++;
	}
	return(0);
}

static void
llist_error_action(unsigned int ui,const char *s)
{
	if(llist_error_flags.print)
                llist_error_perror_arg(ui,s);


        if(ui > LLIST_ERROR_FIRST)
        {

                if( (llist_error_table[llist_error_index(ui)].severity)
                  &&(llist_error_flags.llist_abort) )
                        exit(EX_FAIL);
        }
        if(ui < LLIST_ERROR_FIRST)
        {
                if(llist_error_flags.sys_abort)
                        exit( (ui <= sys_nerr) ? ui : EX_FAIL);
        }
        return;

}

static void
llist_error_perror_arg(unsigned int ui,const char *s)
{
	char * s2 = NULL;
	
        if(ui < LLIST_ERROR_FIRST)
	{
                 s2 = strerror((int)ui);
		 fprintf(stderr,"%s : %s\n",s,s2);
	}

        if(llist_errno > LLIST_ERROR_FIRST)
                fprintf(stderr,"%s : %s\n",s,llist_error_table[llist_error_index(ui)].llist_error_string);

        if(ui == LLIST_ERROR_FIRST)
                fprintf(stderr,"%s : %s\n",s,"Not an error");

        return;
}


void llist_error_throw(unsigned int ui,const char * s)
{
	llist_errno = ui;

	llist_error_action(ui,s);
	
	return;
}

unsigned int llist_error_catch(const char * s)
{
	unsigned int ui = llist_error_get();

	if(s)
		llist_error_action(ui,s);
	if(llist_error_flags.clear)
		llist_error_clear();
	return(ui);
}

void llist_error_clear(void)
{
	llist_errno = 0;
}

static unsigned int llist_error_get(void)
{
	return(llist_errno);
}

unsigned int llist_error_errno(void)
{
	return(llist_error_get());
}

char * 
llist_error_strerror(unsigned int ui)
{
	if(ui < LLIST_ERROR_FIRST)
		return(strerror((int) ui));
	
	if(ui > LLIST_ERROR_FIRST)
		return(llist_error_table[llist_error_index(ui)].llist_error_string);

	return("");
}

void llist_error_perror(const char * s)
{
	(void) llist_error_perror_arg(llist_error_errno(),s);

	return;
}
