#ifndef HAVE_LLIST_ERROR_INCLUDE
	#define HAVE_LLIST_ERROR_INCLUDE
#include <errno.h>
#include <sys/errno.h>
#include <sysexits.h>

#ifndef EX_FAIL
	#define EX_FAIL 63
#endif /* EX_FAIL */

struct llist_error
{
	unsigned int llist_errno;
	char * llist_error_string;
	unsigned int severity;
};

enum 
{
	LLIST_ERROR_FIRST = 1000,
	LLIST_ERROR_EGIGO,
	LLIST_ERROR_EDELE,



	LLIST_ERROR_LAST
} llist_errors;

struct llist_error_FLAGS
{
	char    llist_abort; /* bail on severe errors */
	char    sys_abort;  /* bail on system errors */
	char    print; /* library prints errors or not? */
	char    clear; /* clear error from llist_error_catch */

} llist_error_flags ;



void llist_error_throw(unsigned int,const char *);

void llist_error_clear(void);

unsigned int llist_error_errno(void);

char * llist_error_strerror(unsigned int);

void llist_error_perror(const char *);

#ifndef MAX_BUF
	#define MAX_BUF 1024
#endif /* MAX_BUF */

#define LLIST_ERROR_THROW(w,x,y,z)	\
{\
	char buf[MAX_BUF];\
	snprintf(buf,sizeof(buf),"%s:%d %s()",x,y,z);\
	llist_error_throw(w,buf);\
}

#endif /* HAVE_LLIST_ERROR_INCLUDE */
