#include "spool-remailer.h"


int
main(int argc, char ** argv, char ** envp)
{
	
	FILE * filein = NULL;
	char * filename = NULL;
	
	int ch = 0;
	int i = 0;
	
	int be_verbose = 0;
	int num_spools = 0;
	int num_recips = 0;
	int sendmail_argc = 0;
	int num_messages = 0;

	struct linked_list * recipients = NULL;
	struct linked_list * sendmail_cmd = NULL;
	struct linked_list * spool_files = NULL;

	char ** sendmail_argv = NULL;

	ProgName = argv[0];	

	while ( ( ch = getopt(argc, argv, "E:qs:r:c:C::hvV?") ) != EOF)
		switch(ch)
		{
			case 'c':
				sendmail_cmd = add_linked_list_item(sendmail_cmd,optarg);
				break;
			case 'C':
				if(optarg) MaxChildren = atoi(optarg);
				if(MaxChildren < -1) MaxChildren = 0;
				if(MaxChildren == 0) MaxChildren = SAFE_MAX_CHILDREN; 
				break;
			case 's':
				spool_files = add_linked_list_item(spool_files,optarg);	
				break;
			case 'r':
				recipients = add_linked_list_item(recipients,optarg);	
				break;
			case 'v':
				be_verbose = 1;
				break;
			case 'V':
				print_version();
				break;
			case 'E':
				{
					int i = optind -1;
					while(argv[i])
					{
						sendmail_cmd = add_linked_list_item(sendmail_cmd,argv[i]);
						i++;
					}
				}
				goto nomoreopts;
				break;
			case 'q':
				be_quiet = 1;
				break;
			case 'h':
				/* fall through */
			case '?':
				/* fall through */
			case '*':
				usage();
				break;
		}
			
nomoreopts:

	num_recips = count_linked_list_items(recipients);	
	num_spools = count_linked_list_items(spool_files);
	sendmail_argc = count_linked_list_items(sendmail_cmd);

	/* Default Sendmail Command if none provided */
	if(!sendmail_argc)
	{
		sendmail_cmd = add_linked_list_item(sendmail_cmd,"/usr/sbin/sendmail");
		sendmail_cmd = add_linked_list_item(sendmail_cmd,"-i");
		if(be_verbose)
			sendmail_cmd = add_linked_list_item(sendmail_cmd,"-v");
		if(!num_recips)
			sendmail_cmd = add_linked_list_item(sendmail_cmd,"-t");
		sendmail_argc = count_linked_list_items(sendmail_cmd);
	}

			
	sendmail_cmd = orient_linked_list(sendmail_cmd,0);
	recipients = orient_linked_list(recipients,0);
	spool_files = orient_linked_list(spool_files,0);

	sendmail_argv = (char **) malloc( (num_recips+sendmail_argc+1) * (sizeof(char *)) );
	if(!sendmail_argv)
		exit(ENOMEM);

	while(sendmail_cmd)
	{
		sendmail_cmd = popdel_linked_list_item(sendmail_cmd,(void **)&sendmail_argv[i],NULL);
		i++;
	}
	
	while(recipients)
	{
		recipients = popdel_linked_list_item(recipients,(void **)&sendmail_argv[i],NULL);
		i++;
	}	
	sendmail_argv[i] = NULL;

	if(!spool_files)
	{
		num_messages += send_mail_file(sendmail_argv,stdin,be_verbose);
		goto punt;
	}

	while(spool_files)
	{
		spool_files = popdel_linked_list_item(spool_files,(void **)&filename,NULL);
		if(!filename)
			continue;
		errno = 0;
		filein = fopen(filename,"r");
		if(errno && !be_quiet)
		{	
			fprintf(stderr,"%s : %s\n",filename,strerror(errno));
			continue;
	 	}
		num_messages += send_mail_file(sendmail_argv,filein,be_verbose);
		fclose(filein);
		filein = NULL;	
		free(filename);
		filename = NULL;
	}
punt:
	if(num_messages && be_verbose)
		fprintf(stdout,"%d messages proccessed.\n",num_messages);

	return(0);
	exit(0);
}


int
send_mail_file(char ** sendmail_argv,FILE * filein,int be_verbose)
{
	char * buf = NULL;
	size_t size = 0;
	FILE * streams[] = { NULL };
	pid_t childpid = 0;
	size_t ret_size = 0;
	int childstatus = 0;
	int children = 0;
/* Global Var */
	int maxchildren = MaxChildren;
	int waitoptions = 0;
	int num_messages = 0;

	if(!(filein && sendmail_argv))
		return(EX_FAIL);

		
	while(-1 != (ret_size = getline(&buf,&size,filein)) )
	{
		if(is_new_msg(buf) || (!childpid))
		{
			if(streams[0])
			{
				fclose(streams[0]);
			}
			streams[0] = NULL;
			
			if(childpid)
			{
				/* Child raising and family planning */
				if(maxchildren && ((maxchildren == -1) || (maxchildren > children)) )
					waitoptions = WNOHANG;
				else
					waitoptions = 0;

				if(waitpid(-1,&childstatus,waitoptions))
					children--;
				childpid = 0;
			}	
			childpid = open_sendmail(sendmail_argv,streams,be_verbose);
			pauseme(); /* Debug Call */
			if((-1 == childpid) || (!streams[0]))
				exit(EX_FAIL);
			else
			{	
				children++;
				num_messages++;
			}
		}
		fputs(buf,streams[0]);
		free(buf);
		buf = NULL;
		size = 0;
	}
	return(num_messages);
}


int
open_sendmail(char ** sendmail_argv,FILE ** streams,int be_verbose)
{
	int inpipe[2];
	int ourpid = 0;

	errno = 0;
	if(-1 == pipe(inpipe))
		exit(errno);

	errno = 0;
	streams[0] = fdopen(inpipe[1],"w");
	if(! streams[0])
	{
		if(!be_quiet) perror("fdopen:");
		exit(errno);
	}
	errno = 0;
	ourpid = fork();
	
	if(0 == ourpid)
	{
		/* Child */
		close(inpipe[1]);
		if(-1 == dup2(inpipe[0],STDIN_FILENO))
			_exit(errno);
		execvp(sendmail_argv[0],sendmail_argv);	
		_exit(errno);
	
	}
	else if(-1 == ourpid)
	{
		if(!be_quiet) perror("fork");
		exit(errno);
	}
	else
	{
		/* Parent */
		close(inpipe[0]);
		return(ourpid);	

	}
	
	
}

int
is_new_msg(char * buf)
{
	static char seperator[] = "From ";
	int status = 0;
	
	if(0 == (status = strncmp(buf,seperator,5)) )
	{
		return(1);
	}
	else
		return(0);
}

void
usage(void)
{

	if(be_quiet) goto punt;

	fprintf(stderr,"Usage: %s [-c sendmail-cmd] [-s spool-file] [-r recipient] [-v] [-?h]\n"
	               "-c sendmail-cmd : Sendmail Command line to be used for sending message\n"
	               "                  May occur multiple times. Must occur once per argument\n"
		       "                  Contrast with -E\n"
		       "-C Concurrency	: How many children can we have at once? Blank is default of 10,\n"
		       "                  -1 is infinite (fork bomb) and any other positive integer value\n"
		       "                  will be accepted.\n"
		       "-E commands.... : Commands to Execute once per message.  This ends proccessing of\n"
		       "                  further options. All further arguments will be executed as is once\n"
		       "                  per message. Contrast with -c.\n"
		       "-q              : Extra quiet output.\n"
	               "-s spool-file   : Spool file to be processed. May occur multiple times.\n"
		       "                  If not present, stdin is assumed and read from. Close with EOF.\n"
	               "-r recipient    : Recipient of remailed spool file. May occur multiple times.\n"
	               "-v		: Verbose output.\n"
	               "-V              : Prints the version and exits\n"
	               "-h -?           : This message\n"
		,basename(ProgName));
punt:
	exit(1);


}

void
print_version(void){
	if(!be_quiet) goto punt;
	
        fprintf(stderr,"%s: Version 0.0.4 Copyright Joe Maimon. This program is licensed under the GNU GPL v2\n",basename(ProgName));
punt:
        usage();
}

void
pauseme(void)
{
	int pause_mode = DEBUG;
	while(pause_mode)
	{
		sleep(20);
	}
}
