/*
                                A Sample Filter

   The  following  sample logs each message to a separate temporary file,
   adds  a  recipient  given  with  the -a flag, and rejects a disallowed
   recipient  address given with the -r flag. It recognizes the following
   options:

     -p port The port through which the MTA will connect to the filter.
     -t sec  The timeout value.
     -r addr A recipient to reject.
     -a addr A recipient to add.
     _________________________________________________________________
*/

#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sysexits.h>
#include <unistd.h>
#include <syslog.h>

#include "libmilter/mfapi.h"

#ifndef bool
# define bool   int
# define TRUE   1
# define FALSE  0
#endif /* ! bool */


struct mlfiPriv
{
        char    *mlfi_fname;
        char    *mlfi_connectfrom;
        char    *mlfi_helofrom;
        FILE    *mlfi_fp;
};

#define MLFIPRIV        ((struct mlfiPriv *) smfi_getpriv(ctx))

extern sfsistat         mlfi_cleanup(SMFICTX *, bool);

/* recipients to add and reject (set with -a and -r options) */
char *add = NULL;
char *reject = NULL;

sfsistat
mlfi_connect(ctx, hostname, hostaddr)
         SMFICTX *ctx;
         char *hostname;
         _SOCK_ADDR *hostaddr;
{
	printf("%s: mlfi_connect() hostname=%s\n",
			smfi_getsymval(ctx,"i"),
			hostname);

        /* continue processing */

        return SMFIS_CONTINUE;
}

sfsistat
mlfi_helo(ctx, helohost)
         SMFICTX *ctx;
         char *helohost;
{
	printf("%s: mlfi_helo() helohost=%s\n",
			smfi_getsymval(ctx,"i"),
			helohost);
        return SMFIS_CONTINUE;
}

sfsistat
mlfi_envfrom(ctx, argv)
         SMFICTX *ctx;
         char **argv;
{
	int i = 0;
	
	printf("%s: mlfi_envfrom() ",smfi_getsymval(ctx,"i"));
	while(argv[i])
	{
		printf("argv[%i]=%s ",i,argv[i]); 
		i++;
	}
	printf("\n");
	
        /* continue processing */
        return SMFIS_CONTINUE;
}

sfsistat
mlfi_envrcpt(ctx, argv)
         SMFICTX *ctx;
         char **argv;
{
	int i = 0;
	
	printf("%s: mlfi_envrcpt() ",smfi_getsymval(ctx,"i"));
	while(argv[i])
	{
		printf("argv[%i]=%s ",i,argv[i]); 
		i++;
	}
	printf("\n");
	
	printf("%s: mlfi_envrcpt() macros: "
	       "rcpt_mailer==\"%s\" "
	       "rcpt_host==\"%s\" "
	       "rcpt_addr==\"%s\" "
	       "addr_type==\"%s\" "
	       "\n",
	       smfi_getsymval(ctx,"i"),
	       smfi_getsymval(ctx,"{rcpt_mailer}"),
	       smfi_getsymval(ctx,"{rcpt_host}"),
	       smfi_getsymval(ctx,"{rcpt_addr}"),
	       smfi_getsymval(ctx,"{addr_type")
	      );

	{
		char *p[2];
		char **pp = p;
		int ret_status;
		int ret;
		int i = 0;

		pp[0] = argv[0];
		pp[1] = NULL;
		
		ret = smfi_rewrite(ctx, "spamFriend", &pp, &ret_status);
		if(ret == MI_SUCCESS)
		{
			printf("%s: smfi_rewrite() returned: result code of %i\n",
					smfi_getsymval(ctx,"i"),
					ret_status);
			while(pp[i])
			{
				printf("%s: smfi_rewrite() returned: string \"%s\"\n",
					smfi_getsymval(ctx,"i"),
					pp[i]);
				
				free(pp[i]);
				i++;
						
			}
			free(pp);
			if(ret_status < 0)
			{
				printf("%s: mlfi_envrcpt() returned SMFIS_REJECT\n",
					smfi_getsymval(ctx,"i"));

				return SMFIS_REJECT;
			}
			if(ret_status > 0)
			{
				printf("%s: mlfi_envrcpt() returned SMFIS_ACCEPT\n",
					smfi_getsymval(ctx,"i"));
				return SMFIS_ACCEPT;
			}
		}
		else
			printf("%s: smfi_rewrite() returned %i\n",
					smfi_getsymval(ctx,"i"),
					ret);
	}
        /* continue processing */
        return SMFIS_CONTINUE;
}

sfsistat
mlfi_header(ctx, headerf, headerv)
         SMFICTX *ctx;
         char *headerf;
         unsigned char *headerv;
{
	int i = 0;
	
	printf("%s: mlfi_header() headerf=%s headerv=%s\n",
			smfi_getsymval(ctx,"i"),
			headerf,
			headerv);
	
        /* continue processing */
        return SMFIS_CONTINUE;
}

sfsistat
mlfi_eoh(ctx)
         SMFICTX *ctx;
{
	printf("%s: mlfi_eoh()\n",
			smfi_getsymval(ctx,"i"));
        /* continue processing */
        return SMFIS_CONTINUE;
}

sfsistat
mlfi_body(ctx, bodyp, bodylen)
         SMFICTX *ctx;
         unsigned char *bodyp;
         size_t bodylen;
{
	printf("%s: mlfi_eoh() bodylen=%i BODY\n%s\n",
			smfi_getsymval(ctx,"i"),
			bodylen,
			bodyp
			);
        /* continue processing */
        return SMFIS_CONTINUE;
}

sfsistat
mlfi_eom(ctx)
         SMFICTX *ctx;
{
	printf("%s: mlfi_eom()\n",
			smfi_getsymval(ctx,"i"));
	return SMFIS_ACCEPT;
}

sfsistat
mlfi_abort(ctx)
         SMFICTX *ctx;
{
	printf("%s: mlfi_abort()\n",
			smfi_getsymval(ctx,"i"));
	return SMFIS_CONTINUE;
}

sfsistat
mlfi_close(ctx)
         SMFICTX *ctx;
{
	printf("%s: mlfi_close()\n",
			smfi_getsymval(ctx,"i"));
        return SMFIS_CONTINUE;
}

struct smfiDesc smfilter =
{
        "Verbose-Milter", /* filter name */
        SMFI_VERSION,   /* version code -- do not change */
        SMFIF_ADDHDRS,  /* flags */
        mlfi_connect,       /* connection info filter */
        mlfi_helo,  /* SMTP HELO command filter */
        mlfi_envfrom,       /* envelope sender filter */
        mlfi_envrcpt,       /* envelope recipient filter */
        mlfi_header,        /* header filter */
        mlfi_eoh,   /* end of header */
        mlfi_body,  /* body block filter */
        mlfi_eom,   /* end of message */
        mlfi_abort, /* message aborted */
        mlfi_close, /* connection cleanup */
};

static void
usage(prog)
        char *prog;
{
        fprintf(stderr,
                "Usage: %s -p socket-addr [-t timeout]\n",
                prog);
}

int
main(argc, argv)
         int argc;
         char **argv;
{
        bool setconn = FALSE;
        int c;
        const char *args = "wgd:p:t:h";
        extern char *optarg;

        /* Process command line options */
        while ((c = getopt(argc, argv, args)) != -1)
        {
                switch (c)
                {
		  case 'd':
			smfi_setdbg(atoi(optarg));
			break;
                  case 'p':
                        if (optarg == NULL || *optarg == '\0')
                        {
                                (void) fprintf(stderr, "Illegal conn: %s\n",
                                               optarg);
                                exit(EX_USAGE);
                        }
                        if (smfi_setconn(optarg) == MI_FAILURE)
                        {
                                (void) fprintf(stderr,
                                               "smfi_setconn failed\n");
                                exit(EX_SOFTWARE);
                        }

                        /*
                        **  If we're using a local socket, make sure it
                        **  doesn't already exist.  Don't ever run this
                        **  code as root!!
                        */

                        if (strncasecmp(optarg, "unix:", 5) == 0)
                                unlink(optarg + 5);
                        else if (strncasecmp(optarg, "local:", 6) == 0)
                                unlink(optarg + 6);
                        setconn = TRUE;
                        break;

                  case 't':
                        if (optarg == NULL || *optarg == '\0')
                        {
                                (void) fprintf(stderr, "Illegal timeout: %s\n",
                                               optarg);
                                exit(EX_USAGE);
                        }
                        if (smfi_settimeout(atoi(optarg)) == MI_FAILURE)
                        {
                                (void) fprintf(stderr,
                                               "smfi_settimeout failed\n");
                                exit(EX_SOFTWARE);
                        }
                        break;
		  case 'w':
			/*Turn on Rewrite/Eagain support*/
			smfilter.xxfi_flags |= SMFIF_REWRITE;
			break;
		  case 'g':
			smfilter.xxfi_flags |= SMFIF_EAGAIN; 
			break;

                  case 'h':
                  default:
                        usage(argv[0]);
                        exit(EX_USAGE);
                }
        }
        if (!setconn)
        {
                fprintf(stderr, "%s: Missing required -p argument\n", argv[0]);
                usage(argv[0]);
                exit(EX_USAGE);
        }
        if (smfi_register(smfilter) == MI_FAILURE)
        {
                fprintf(stderr, "smfi_register failed\n");
                exit(EX_UNAVAILABLE);
        }
	openlog(smfilter.xxfi_name,LOG_PID,LOG_MAIL);
        return smfi_main();
}

/* eof */

/*
     _________________________________________________________________

   Copyright  (c)  2000-2003 Sendmail, Inc. and its suppliers. All rights
   reserved.
   By using this file, you agree to the terms and conditions set forth in
   the LICENSE.

 */
